<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cuis ServiceType
 * @subpackage Services
 */
class Cuis extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cuisMasivo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CuisMasivo $parameters
     * @return \StructType\CuisMasivoResponse|bool
     */
    public function cuisMasivo(\StructType\CuisMasivo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cuisMasivo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cuis
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cuis $parameters
     * @return \StructType\CuisResponse|bool
     */
    public function cuis(\StructType\Cuis $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cuis($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CuisMasivoResponse|\StructType\CuisResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
