<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cufd ServiceType
 * @subpackage Services
 */
class Cufd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cufd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cufd $parameters
     * @return \StructType\CufdResponse|bool
     */
    public function cufd(\StructType\Cufd $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cufd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named cufdMasivo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CufdMasivo $parameters
     * @return \StructType\CufdMasivoResponse|bool
     */
    public function cufdMasivo(\StructType\CufdMasivo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cufdMasivo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CufdMasivoResponse|\StructType\CufdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
