<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resultado StructType
 * @subpackage Structs
 */
class Resultado extends AbstractStructBase
{
    /**
     * The codigo
     * @var string
     */
    public $codigo;
    /**
     * The descripcion
     * @var string
     */
    public $descripcion;
    /**
     * The codigoSeguimiento
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $codigoSeguimiento;
    /**
     * Constructor method for Resultado
     * @uses Resultado::setCodigo()
     * @uses Resultado::setDescripcion()
     * @uses Resultado::setCodigoSeguimiento()
     * @param string $codigo
     * @param string $descripcion
     * @param string $codigoSeguimiento
     */
    public function __construct($codigo = null, $descripcion = null, $codigoSeguimiento = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescripcion($descripcion)
            ->setCodigoSeguimiento($codigoSeguimiento);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\Resultado
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \StructType\Resultado
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
    /**
     * Get codigoSeguimiento value
     * @return string|null
     */
    public function getCodigoSeguimiento()
    {
        return $this->codigoSeguimiento;
    }
    /**
     * Set codigoSeguimiento value
     * @param string $codigoSeguimiento
     * @return \StructType\Resultado
     */
    public function setCodigoSeguimiento($codigoSeguimiento = null)
    {
        // validation for constraint: string
        if (!is_null($codigoSeguimiento) && !is_string($codigoSeguimiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoSeguimiento, true), gettype($codigoSeguimiento)), __LINE__);
        }
        $this->codigoSeguimiento = $codigoSeguimiento;
        return $this;
    }
}
