<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OGNIFs StructType
 * @subpackage Structs
 */
class OGNIFs extends AbstractStructBase
{
    /**
     * The organoGestor
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\UnidadDir3
     */
    public $organoGestor;
    /**
     * The nif
     * @var string
     */
    public $nif;
    /**
     * Constructor method for OGNIFs
     * @uses OGNIFs::setOrganoGestor()
     * @uses OGNIFs::setNif()
     * @param \StructType\UnidadDir3 $organoGestor
     * @param string $nif
     */
    public function __construct(\StructType\UnidadDir3 $organoGestor = null, $nif = null)
    {
        $this
            ->setOrganoGestor($organoGestor)
            ->setNif($nif);
    }
    /**
     * Get organoGestor value
     * @return \StructType\UnidadDir3|null
     */
    public function getOrganoGestor()
    {
        return $this->organoGestor;
    }
    /**
     * Set organoGestor value
     * @param \StructType\UnidadDir3 $organoGestor
     * @return \StructType\OGNIFs
     */
    public function setOrganoGestor(\StructType\UnidadDir3 $organoGestor = null)
    {
        $this->organoGestor = $organoGestor;
        return $this;
    }
    /**
     * Get nif value
     * @return string|null
     */
    public function getNif()
    {
        return $this->nif;
    }
    /**
     * Set nif value
     * @param string $nif
     * @return \StructType\OGNIFs
     */
    public function setNif($nif = null)
    {
        // validation for constraint: string
        if (!is_null($nif) && !is_string($nif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nif, true), gettype($nif)), __LINE__);
        }
        $this->nif = $nif;
        return $this;
    }
}
