<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FacturaFile StructType
 * @subpackage Structs
 */
class FacturaFile extends AbstractStructBase
{
    /**
     * The factura
     * @var string
     */
    public $factura;
    /**
     * The nombre
     * @var string
     */
    public $nombre;
    /**
     * The mime
     * @var string
     */
    public $mime;
    /**
     * Constructor method for FacturaFile
     * @uses FacturaFile::setFactura()
     * @uses FacturaFile::setNombre()
     * @uses FacturaFile::setMime()
     * @param string $factura
     * @param string $nombre
     * @param string $mime
     */
    public function __construct($factura = null, $nombre = null, $mime = null)
    {
        $this
            ->setFactura($factura)
            ->setNombre($nombre)
            ->setMime($mime);
    }
    /**
     * Get factura value
     * @return string|null
     */
    public function getFactura()
    {
        return $this->factura;
    }
    /**
     * Set factura value
     * @param string $factura
     * @return \StructType\FacturaFile
     */
    public function setFactura($factura = null)
    {
        // validation for constraint: string
        if (!is_null($factura) && !is_string($factura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($factura, true), gettype($factura)), __LINE__);
        }
        $this->factura = $factura;
        return $this;
    }
    /**
     * Get nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->nombre;
    }
    /**
     * Set nombre value
     * @param string $nombre
     * @return \StructType\FacturaFile
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        $this->nombre = $nombre;
        return $this;
    }
    /**
     * Get mime value
     * @return string|null
     */
    public function getMime()
    {
        return $this->mime;
    }
    /**
     * Set mime value
     * @param string $mime
     * @return \StructType\FacturaFile
     */
    public function setMime($mime = null)
    {
        // validation for constraint: string
        if (!is_null($mime) && !is_string($mime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mime, true), gettype($mime)), __LINE__);
        }
        $this->mime = $mime;
        return $this;
    }
}
