<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Estado StructType
 * @subpackage Structs
 */
class Estado extends AbstractStructBase
{
    /**
     * The nombre
     * @var string
     */
    public $nombre;
    /**
     * The codigo
     * @var string
     */
    public $codigo;
    /**
     * The descripcion
     * @var string
     */
    public $descripcion;
    /**
     * Constructor method for Estado
     * @uses Estado::setNombre()
     * @uses Estado::setCodigo()
     * @uses Estado::setDescripcion()
     * @param string $nombre
     * @param string $codigo
     * @param string $descripcion
     */
    public function __construct($nombre = null, $codigo = null, $descripcion = null)
    {
        $this
            ->setNombre($nombre)
            ->setCodigo($codigo)
            ->setDescripcion($descripcion);
    }
    /**
     * Get nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->nombre;
    }
    /**
     * Set nombre value
     * @param string $nombre
     * @return \StructType\Estado
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        $this->nombre = $nombre;
        return $this;
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\Estado
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \StructType\Estado
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
}
