<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultarRelacionesResponse StructType
 * @subpackage Structs
 */
class ConsultarRelacionesResponse extends AbstractStructBase
{
    /**
     * The resultado
     * @var \StructType\Resultado
     */
    public $resultado;
    /**
     * The relaciones
     * Meta information extracted from the WSDL
     * - arrayType: tns:OGUTOC[]
     * - base: soap-enc:Array
     * - nillable: true
     * - ref: soap-enc:arrayType
     * @var \StructType\OGUTOC[]
     */
    public $relaciones;
    /**
     * Constructor method for ConsultarRelacionesResponse
     * @uses ConsultarRelacionesResponse::setResultado()
     * @uses ConsultarRelacionesResponse::setRelaciones()
     * @param \StructType\Resultado $resultado
     * @param \StructType\OGUTOC[] $relaciones
     */
    public function __construct(\StructType\Resultado $resultado = null, array $relaciones = array())
    {
        $this
            ->setResultado($resultado)
            ->setRelaciones($relaciones);
    }
    /**
     * Get resultado value
     * @return \StructType\Resultado|null
     */
    public function getResultado()
    {
        return $this->resultado;
    }
    /**
     * Set resultado value
     * @param \StructType\Resultado $resultado
     * @return \StructType\ConsultarRelacionesResponse
     */
    public function setResultado(\StructType\Resultado $resultado = null)
    {
        $this->resultado = $resultado;
        return $this;
    }
    /**
     * Get relaciones value
     * @return \StructType\OGUTOC[]|null
     */
    public function getRelaciones()
    {
        return $this->relaciones;
    }
    /**
     * This method is responsible for validating the values passed to the setRelaciones method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelaciones method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelacionesForArrayConstraintsFromSetRelaciones(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consultarRelacionesResponseRelacionesItem) {
            // validation for constraint: itemType
            if (!$consultarRelacionesResponseRelacionesItem instanceof \StructType\OGUTOC) {
                $invalidValues[] = is_object($consultarRelacionesResponseRelacionesItem) ? get_class($consultarRelacionesResponseRelacionesItem) : sprintf('%s(%s)', gettype($consultarRelacionesResponseRelacionesItem), var_export($consultarRelacionesResponseRelacionesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relaciones property can only contain items of type \StructType\OGUTOC, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relaciones value
     * @throws \InvalidArgumentException
     * @param \StructType\OGUTOC[] $relaciones
     * @return \StructType\ConsultarRelacionesResponse
     */
    public function setRelaciones(array $relaciones = array())
    {
        // validation for constraint: array
        if ('' !== ($relacionesArrayErrorMessage = self::validateRelacionesForArrayConstraintsFromSetRelaciones($relaciones))) {
            throw new \InvalidArgumentException($relacionesArrayErrorMessage, __LINE__);
        }
        $this->relaciones = $relaciones;
        return $this;
    }
    /**
     * Add item to relaciones value
     * @throws \InvalidArgumentException
     * @param \StructType\OGUTOC $item
     * @return \StructType\ConsultarRelacionesResponse
     */
    public function addToRelaciones(\StructType\OGUTOC $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OGUTOC) {
            throw new \InvalidArgumentException(sprintf('The relaciones property can only contain items of type \StructType\OGUTOC, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relaciones[] = $item;
        return $this;
    }
}
