<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultarEstadosResponse StructType
 * @subpackage Structs
 */
class ConsultarEstadosResponse extends AbstractStructBase
{
    /**
     * The resultado
     * @var \StructType\Resultado
     */
    public $resultado;
    /**
     * The estados
     * Meta information extracted from the WSDL
     * - arrayType: tns:Estado[]
     * - base: soap-enc:Array
     * - nillable: true
     * - ref: soap-enc:arrayType
     * @var \StructType\Estado[]
     */
    public $estados;
    /**
     * Constructor method for ConsultarEstadosResponse
     * @uses ConsultarEstadosResponse::setResultado()
     * @uses ConsultarEstadosResponse::setEstados()
     * @param \StructType\Resultado $resultado
     * @param \StructType\Estado[] $estados
     */
    public function __construct(\StructType\Resultado $resultado = null, array $estados = array())
    {
        $this
            ->setResultado($resultado)
            ->setEstados($estados);
    }
    /**
     * Get resultado value
     * @return \StructType\Resultado|null
     */
    public function getResultado()
    {
        return $this->resultado;
    }
    /**
     * Set resultado value
     * @param \StructType\Resultado $resultado
     * @return \StructType\ConsultarEstadosResponse
     */
    public function setResultado(\StructType\Resultado $resultado = null)
    {
        $this->resultado = $resultado;
        return $this;
    }
    /**
     * Get estados value
     * @return \StructType\Estado[]|null
     */
    public function getEstados()
    {
        return $this->estados;
    }
    /**
     * This method is responsible for validating the values passed to the setEstados method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstados method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstadosForArrayConstraintsFromSetEstados(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consultarEstadosResponseEstadosItem) {
            // validation for constraint: itemType
            if (!$consultarEstadosResponseEstadosItem instanceof \StructType\Estado) {
                $invalidValues[] = is_object($consultarEstadosResponseEstadosItem) ? get_class($consultarEstadosResponseEstadosItem) : sprintf('%s(%s)', gettype($consultarEstadosResponseEstadosItem), var_export($consultarEstadosResponseEstadosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The estados property can only contain items of type \StructType\Estado, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set estados value
     * @throws \InvalidArgumentException
     * @param \StructType\Estado[] $estados
     * @return \StructType\ConsultarEstadosResponse
     */
    public function setEstados(array $estados = array())
    {
        // validation for constraint: array
        if ('' !== ($estadosArrayErrorMessage = self::validateEstadosForArrayConstraintsFromSetEstados($estados))) {
            throw new \InvalidArgumentException($estadosArrayErrorMessage, __LINE__);
        }
        $this->estados = $estados;
        return $this;
    }
    /**
     * Add item to estados value
     * @throws \InvalidArgumentException
     * @param \StructType\Estado $item
     * @return \StructType\ConsultarEstadosResponse
     */
    public function addToEstados(\StructType\Estado $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Estado) {
            throw new \InvalidArgumentException(sprintf('The estados property can only contain items of type \StructType\Estado, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->estados[] = $item;
        return $this;
    }
}
