<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enviar ServiceType
 * @subpackage Services
 */
class Enviar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named enviarFactura
     * Meta information extracted from the WSDL
     * - documentation: Remite un factura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarFacturaRequest $request
     * @return \StructType\EnviarFacturaResponse|bool
     */
    public function enviarFactura(\StructType\EnviarFacturaRequest $request)
    {
        try {
            $this->setResult($this->getSoapClient()->enviarFactura($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EnviarFacturaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
