<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consultar ServiceType
 * @subpackage Services
 */
class Consultar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named consultarFactura
     * Meta information extracted from the WSDL
     * - documentation: Consulta el estado de una factura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $numeroRegistro
     * @return \StructType\ConsultarFacturaResponse|bool
     */
    public function consultarFactura($numeroRegistro)
    {
        try {
            $this->setResult($this->getSoapClient()->consultarFactura($numeroRegistro));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultarEstados
     * Meta information extracted from the WSDL
     * - documentation: Consultar los estados publicos de una factura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\ConsultarEstadosResponse|bool
     */
    public function consultarEstados()
    {
        try {
            $this->setResult($this->getSoapClient()->consultarEstados());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultarUnidades
     * Meta information extracted from the WSDL
     * - documentation: Consultar las relaciones og-ut-oc existentes en el sistema.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\ConsultarRelacionesResponse|bool
     */
    public function consultarUnidades()
    {
        try {
            $this->setResult($this->getSoapClient()->consultarUnidades());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultarNIFs
     * Meta information extracted from the WSDL
     * - documentation: Consultar los nifs og existentes en el sistema.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\ConsultarNIFsResponse|bool
     */
    public function consultarNIFs()
    {
        try {
            $this->setResult($this->getSoapClient()->consultarNIFs());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultarAdministraciones
     * Meta information extracted from the WSDL
     * - documentation: Retorna un listado de AAPP de primer nivel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\ConsultarAdministracionesResponse|bool
     */
    public function consultarAdministraciones()
    {
        try {
            $this->setResult($this->getSoapClient()->consultarAdministraciones());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * consultarAdministracionesRepositorio
     * Meta information extracted from the WSDL
     * - documentation: Retorna un listado de AAPP de primer nivel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\ConsultarAdministracionesRepositorioResponse|bool
     */
    public function consultarAdministracionesRepositorio()
    {
        try {
            $this->setResult($this->getSoapClient()->consultarAdministracionesRepositorio());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultarUnidadesPorAdministracion
     * Meta information extracted from the WSDL
     * - documentation: Retorna un listado de relaciones og-ut-oc visibles por Administracion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $codigoDir
     * @return \StructType\ConsultarRelacionesPorAdministracionResponse|bool
     */
    public function consultarUnidadesPorAdministracion($codigoDir)
    {
        try {
            $this->setResult($this->getSoapClient()->consultarUnidadesPorAdministracion($codigoDir));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultarNIFsPorAdministracion
     * Meta information extracted from the WSDL
     * - documentation: Retorna un listado de nifs de og visibles por Administracion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $codigoDir
     * @return \StructType\ConsultarNIFsPorAdministracionResponse|bool
     */
    public function consultarNIFsPorAdministracion($codigoDir)
    {
        try {
            $this->setResult($this->getSoapClient()->consultarNIFsPorAdministracion($codigoDir));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named consultarListadoFacturas
     * Meta information extracted from the WSDL
     * - documentation: Consulta los estados de una lista de facturas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $request
     * @return \StructType\ConsultaListadoFacturaResponse|bool
     */
    public function consultarListadoFacturas($request)
    {
        try {
            $this->setResult($this->getSoapClient()->consultarListadoFacturas($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsultaListadoFacturaResponse|\StructType\ConsultarAdministracionesRepositorioResponse|\StructType\ConsultarAdministracionesResponse|\StructType\ConsultarEstadosResponse|\StructType\ConsultarFacturaResponse|\StructType\ConsultarNIFsPorAdministracionResponse|\StructType\ConsultarNIFsResponse|\StructType\ConsultarRelacionesPorAdministracionResponse|\StructType\ConsultarRelacionesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
