<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstadoFactura StructType
 * @subpackage Structs
 */
class EstadoFactura extends AbstractStructBase
{
    /**
     * The codigo
     * @var string
     */
    public $codigo;
    /**
     * The descripcion
     * @var string
     */
    public $descripcion;
    /**
     * The motivo
     * @var string
     */
    public $motivo;
    /**
     * Constructor method for EstadoFactura
     * @uses EstadoFactura::setCodigo()
     * @uses EstadoFactura::setDescripcion()
     * @uses EstadoFactura::setMotivo()
     * @param string $codigo
     * @param string $descripcion
     * @param string $motivo
     */
    public function __construct($codigo = null, $descripcion = null, $motivo = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescripcion($descripcion)
            ->setMotivo($motivo);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\EstadoFactura
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \StructType\EstadoFactura
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
    /**
     * Get motivo value
     * @return string|null
     */
    public function getMotivo()
    {
        return $this->motivo;
    }
    /**
     * Set motivo value
     * @param string $motivo
     * @return \StructType\EstadoFactura
     */
    public function setMotivo($motivo = null)
    {
        // validation for constraint: string
        if (!is_null($motivo) && !is_string($motivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivo, true), gettype($motivo)), __LINE__);
        }
        $this->motivo = $motivo;
        return $this;
    }
}
