<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultarNIFsResponse StructType
 * @subpackage Structs
 */
class ConsultarNIFsResponse extends AbstractStructBase
{
    /**
     * The resultado
     * @var \StructType\Resultado
     */
    public $resultado;
    /**
     * The nifs
     * Meta information extracted from the WSDL
     * - arrayType: tns:OGNIFs[]
     * - base: soap-enc:Array
     * - nillable: true
     * - ref: soap-enc:arrayType
     * @var \StructType\OGNIFs[]
     */
    public $nifs;
    /**
     * Constructor method for ConsultarNIFsResponse
     * @uses ConsultarNIFsResponse::setResultado()
     * @uses ConsultarNIFsResponse::setNifs()
     * @param \StructType\Resultado $resultado
     * @param \StructType\OGNIFs[] $nifs
     */
    public function __construct(\StructType\Resultado $resultado = null, array $nifs = array())
    {
        $this
            ->setResultado($resultado)
            ->setNifs($nifs);
    }
    /**
     * Get resultado value
     * @return \StructType\Resultado|null
     */
    public function getResultado()
    {
        return $this->resultado;
    }
    /**
     * Set resultado value
     * @param \StructType\Resultado $resultado
     * @return \StructType\ConsultarNIFsResponse
     */
    public function setResultado(\StructType\Resultado $resultado = null)
    {
        $this->resultado = $resultado;
        return $this;
    }
    /**
     * Get nifs value
     * @return \StructType\OGNIFs[]|null
     */
    public function getNifs()
    {
        return $this->nifs;
    }
    /**
     * This method is responsible for validating the values passed to the setNifs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNifs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNifsForArrayConstraintsFromSetNifs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consultarNIFsResponseNifsItem) {
            // validation for constraint: itemType
            if (!$consultarNIFsResponseNifsItem instanceof \StructType\OGNIFs) {
                $invalidValues[] = is_object($consultarNIFsResponseNifsItem) ? get_class($consultarNIFsResponseNifsItem) : sprintf('%s(%s)', gettype($consultarNIFsResponseNifsItem), var_export($consultarNIFsResponseNifsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nifs property can only contain items of type \StructType\OGNIFs, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nifs value
     * @throws \InvalidArgumentException
     * @param \StructType\OGNIFs[] $nifs
     * @return \StructType\ConsultarNIFsResponse
     */
    public function setNifs(array $nifs = array())
    {
        // validation for constraint: array
        if ('' !== ($nifsArrayErrorMessage = self::validateNifsForArrayConstraintsFromSetNifs($nifs))) {
            throw new \InvalidArgumentException($nifsArrayErrorMessage, __LINE__);
        }
        $this->nifs = $nifs;
        return $this;
    }
    /**
     * Add item to nifs value
     * @throws \InvalidArgumentException
     * @param \StructType\OGNIFs $item
     * @return \StructType\ConsultarNIFsResponse
     */
    public function addToNifs(\StructType\OGNIFs $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OGNIFs) {
            throw new \InvalidArgumentException(sprintf('The nifs property can only contain items of type \StructType\OGNIFs, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nifs[] = $item;
        return $this;
    }
}
