<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultarFactura StructType
 * @subpackage Structs
 */
class ConsultarFactura extends AbstractStructBase
{
    /**
     * The numeroRegistro
     * @var string
     */
    public $numeroRegistro;
    /**
     * The tramitacion
     * @var \StructType\EstadoFactura
     */
    public $tramitacion;
    /**
     * The anulacion
     * @var \StructType\EstadoFactura
     */
    public $anulacion;
    /**
     * Constructor method for ConsultarFactura
     * @uses ConsultarFactura::setNumeroRegistro()
     * @uses ConsultarFactura::setTramitacion()
     * @uses ConsultarFactura::setAnulacion()
     * @param string $numeroRegistro
     * @param \StructType\EstadoFactura $tramitacion
     * @param \StructType\EstadoFactura $anulacion
     */
    public function __construct($numeroRegistro = null, \StructType\EstadoFactura $tramitacion = null, \StructType\EstadoFactura $anulacion = null)
    {
        $this
            ->setNumeroRegistro($numeroRegistro)
            ->setTramitacion($tramitacion)
            ->setAnulacion($anulacion);
    }
    /**
     * Get numeroRegistro value
     * @return string|null
     */
    public function getNumeroRegistro()
    {
        return $this->numeroRegistro;
    }
    /**
     * Set numeroRegistro value
     * @param string $numeroRegistro
     * @return \StructType\ConsultarFactura
     */
    public function setNumeroRegistro($numeroRegistro = null)
    {
        // validation for constraint: string
        if (!is_null($numeroRegistro) && !is_string($numeroRegistro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroRegistro, true), gettype($numeroRegistro)), __LINE__);
        }
        $this->numeroRegistro = $numeroRegistro;
        return $this;
    }
    /**
     * Get tramitacion value
     * @return \StructType\EstadoFactura|null
     */
    public function getTramitacion()
    {
        return $this->tramitacion;
    }
    /**
     * Set tramitacion value
     * @param \StructType\EstadoFactura $tramitacion
     * @return \StructType\ConsultarFactura
     */
    public function setTramitacion(\StructType\EstadoFactura $tramitacion = null)
    {
        $this->tramitacion = $tramitacion;
        return $this;
    }
    /**
     * Get anulacion value
     * @return \StructType\EstadoFactura|null
     */
    public function getAnulacion()
    {
        return $this->anulacion;
    }
    /**
     * Set anulacion value
     * @param \StructType\EstadoFactura $anulacion
     * @return \StructType\ConsultarFactura
     */
    public function setAnulacion(\StructType\EstadoFactura $anulacion = null)
    {
        $this->anulacion = $anulacion;
        return $this;
    }
}
