<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultaListadoFacturaResponse StructType
 * @subpackage Structs
 */
class ConsultaListadoFacturaResponse extends AbstractStructBase
{
    /**
     * The resultado
     * @var \StructType\Resultado
     */
    public $resultado;
    /**
     * The facturas
     * Meta information extracted from the WSDL
     * - arrayType: tns:ConsultarListadoFactura[]
     * - base: soap-enc:Array
     * - nillable: true
     * - ref: soap-enc:arrayType
     * @var \StructType\ConsultarListadoFactura[]
     */
    public $facturas;
    /**
     * Constructor method for ConsultaListadoFacturaResponse
     * @uses ConsultaListadoFacturaResponse::setResultado()
     * @uses ConsultaListadoFacturaResponse::setFacturas()
     * @param \StructType\Resultado $resultado
     * @param \StructType\ConsultarListadoFactura[] $facturas
     */
    public function __construct(\StructType\Resultado $resultado = null, array $facturas = array())
    {
        $this
            ->setResultado($resultado)
            ->setFacturas($facturas);
    }
    /**
     * Get resultado value
     * @return \StructType\Resultado|null
     */
    public function getResultado()
    {
        return $this->resultado;
    }
    /**
     * Set resultado value
     * @param \StructType\Resultado $resultado
     * @return \StructType\ConsultaListadoFacturaResponse
     */
    public function setResultado(\StructType\Resultado $resultado = null)
    {
        $this->resultado = $resultado;
        return $this;
    }
    /**
     * Get facturas value
     * @return \StructType\ConsultarListadoFactura[]|null
     */
    public function getFacturas()
    {
        return $this->facturas;
    }
    /**
     * This method is responsible for validating the values passed to the setFacturas method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFacturas method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFacturasForArrayConstraintsFromSetFacturas(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $consultaListadoFacturaResponseFacturasItem) {
            // validation for constraint: itemType
            if (!$consultaListadoFacturaResponseFacturasItem instanceof \StructType\ConsultarListadoFactura) {
                $invalidValues[] = is_object($consultaListadoFacturaResponseFacturasItem) ? get_class($consultaListadoFacturaResponseFacturasItem) : sprintf('%s(%s)', gettype($consultaListadoFacturaResponseFacturasItem), var_export($consultaListadoFacturaResponseFacturasItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The facturas property can only contain items of type \StructType\ConsultarListadoFactura, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set facturas value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsultarListadoFactura[] $facturas
     * @return \StructType\ConsultaListadoFacturaResponse
     */
    public function setFacturas(array $facturas = array())
    {
        // validation for constraint: array
        if ('' !== ($facturasArrayErrorMessage = self::validateFacturasForArrayConstraintsFromSetFacturas($facturas))) {
            throw new \InvalidArgumentException($facturasArrayErrorMessage, __LINE__);
        }
        $this->facturas = $facturas;
        return $this;
    }
    /**
     * Add item to facturas value
     * @throws \InvalidArgumentException
     * @param \StructType\ConsultarListadoFactura $item
     * @return \StructType\ConsultaListadoFacturaResponse
     */
    public function addToFacturas(\StructType\ConsultarListadoFactura $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConsultarListadoFactura) {
            throw new \InvalidArgumentException(sprintf('The facturas property can only contain items of type \StructType\ConsultarListadoFactura, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->facturas[] = $item;
        return $this;
    }
}
