<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnexoFile StructType
 * @subpackage Structs
 */
class AnexoFile extends AbstractStructBase
{
    /**
     * The anexo
     * @var string
     */
    public $anexo;
    /**
     * The nombre
     * @var string
     */
    public $nombre;
    /**
     * The mime
     * @var string
     */
    public $mime;
    /**
     * Constructor method for AnexoFile
     * @uses AnexoFile::setAnexo()
     * @uses AnexoFile::setNombre()
     * @uses AnexoFile::setMime()
     * @param string $anexo
     * @param string $nombre
     * @param string $mime
     */
    public function __construct($anexo = null, $nombre = null, $mime = null)
    {
        $this
            ->setAnexo($anexo)
            ->setNombre($nombre)
            ->setMime($mime);
    }
    /**
     * Get anexo value
     * @return string|null
     */
    public function getAnexo()
    {
        return $this->anexo;
    }
    /**
     * Set anexo value
     * @param string $anexo
     * @return \StructType\AnexoFile
     */
    public function setAnexo($anexo = null)
    {
        // validation for constraint: string
        if (!is_null($anexo) && !is_string($anexo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anexo, true), gettype($anexo)), __LINE__);
        }
        $this->anexo = $anexo;
        return $this;
    }
    /**
     * Get nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->nombre;
    }
    /**
     * Set nombre value
     * @param string $nombre
     * @return \StructType\AnexoFile
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        $this->nombre = $nombre;
        return $this;
    }
    /**
     * Get mime value
     * @return string|null
     */
    public function getMime()
    {
        return $this->mime;
    }
    /**
     * Set mime value
     * @param string $mime
     * @return \StructType\AnexoFile
     */
    public function setMime($mime = null)
    {
        // validation for constraint: string
        if (!is_null($mime) && !is_string($mime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mime, true), gettype($mime)), __LINE__);
        }
        $this->mime = $mime;
        return $this;
    }
}
