<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Anular ServiceType
 * @subpackage Services
 */
class Anular extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named anularFactura
     * Meta information extracted from the WSDL
     * - documentation: Solicita la anulacion de una factura
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $numeroRegistro
     * @param string $motivo
     * @return \StructType\AnularFacturaResponse|bool
     */
    public function anularFactura($numeroRegistro, $motivo)
    {
        try {
            $this->setResult($this->getSoapClient()->anularFactura($numeroRegistro, $motivo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AnularFacturaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
