<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnviarFacturaRequest StructType
 * @subpackage Structs
 */
class EnviarFacturaRequest extends AbstractStructBase
{
    /**
     * The correo
     * @var string
     */
    public $correo;
    /**
     * The factura
     * @var \StructType\FacturaFile
     */
    public $factura;
    /**
     * The anexos
     * Meta information extracted from the WSDL
     * - arrayType: tns:AnexoFile[]
     * - base: soap-enc:Array
     * - nillable: true
     * - ref: soap-enc:arrayType
     * @var \StructType\AnexoFile[]
     */
    public $anexos;
    /**
     * Constructor method for EnviarFacturaRequest
     * @uses EnviarFacturaRequest::setCorreo()
     * @uses EnviarFacturaRequest::setFactura()
     * @uses EnviarFacturaRequest::setAnexos()
     * @param string $correo
     * @param \StructType\FacturaFile $factura
     * @param \StructType\AnexoFile[] $anexos
     */
    public function __construct($correo = null, \StructType\FacturaFile $factura = null, array $anexos = array())
    {
        $this
            ->setCorreo($correo)
            ->setFactura($factura)
            ->setAnexos($anexos);
    }
    /**
     * Get correo value
     * @return string|null
     */
    public function getCorreo()
    {
        return $this->correo;
    }
    /**
     * Set correo value
     * @param string $correo
     * @return \StructType\EnviarFacturaRequest
     */
    public function setCorreo($correo = null)
    {
        // validation for constraint: string
        if (!is_null($correo) && !is_string($correo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correo, true), gettype($correo)), __LINE__);
        }
        $this->correo = $correo;
        return $this;
    }
    /**
     * Get factura value
     * @return \StructType\FacturaFile|null
     */
    public function getFactura()
    {
        return $this->factura;
    }
    /**
     * Set factura value
     * @param \StructType\FacturaFile $factura
     * @return \StructType\EnviarFacturaRequest
     */
    public function setFactura(\StructType\FacturaFile $factura = null)
    {
        $this->factura = $factura;
        return $this;
    }
    /**
     * Get anexos value
     * @return \StructType\AnexoFile[]|null
     */
    public function getAnexos()
    {
        return $this->anexos;
    }
    /**
     * This method is responsible for validating the values passed to the setAnexos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnexos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnexosForArrayConstraintsFromSetAnexos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enviarFacturaRequestAnexosItem) {
            // validation for constraint: itemType
            if (!$enviarFacturaRequestAnexosItem instanceof \StructType\AnexoFile) {
                $invalidValues[] = is_object($enviarFacturaRequestAnexosItem) ? get_class($enviarFacturaRequestAnexosItem) : sprintf('%s(%s)', gettype($enviarFacturaRequestAnexosItem), var_export($enviarFacturaRequestAnexosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The anexos property can only contain items of type \StructType\AnexoFile, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set anexos value
     * @throws \InvalidArgumentException
     * @param \StructType\AnexoFile[] $anexos
     * @return \StructType\EnviarFacturaRequest
     */
    public function setAnexos(array $anexos = array())
    {
        // validation for constraint: array
        if ('' !== ($anexosArrayErrorMessage = self::validateAnexosForArrayConstraintsFromSetAnexos($anexos))) {
            throw new \InvalidArgumentException($anexosArrayErrorMessage, __LINE__);
        }
        $this->anexos = $anexos;
        return $this;
    }
    /**
     * Add item to anexos value
     * @throws \InvalidArgumentException
     * @param \StructType\AnexoFile $item
     * @return \StructType\EnviarFacturaRequest
     */
    public function addToAnexos(\StructType\AnexoFile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnexoFile) {
            throw new \InvalidArgumentException(sprintf('The anexos property can only contain items of type \StructType\AnexoFile, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->anexos[] = $item;
        return $this;
    }
}
