<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnviarFactura StructType
 * @subpackage Structs
 */
class EnviarFactura extends AbstractStructBase
{
    /**
     * The numeroRegistro
     * @var string
     */
    public $numeroRegistro;
    /**
     * The organoGestor
     * @var string
     */
    public $organoGestor;
    /**
     * The unidadTramitadora
     * @var string
     */
    public $unidadTramitadora;
    /**
     * The oficinaContable
     * @var string
     */
    public $oficinaContable;
    /**
     * The identificadorEmisor
     * @var string
     */
    public $identificadorEmisor;
    /**
     * The numeroFactura
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $numeroFactura;
    /**
     * The serieFactura
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $serieFactura;
    /**
     * The fechaRecepcion
     * @var string
     */
    public $fechaRecepcion;
    /**
     * Constructor method for EnviarFactura
     * @uses EnviarFactura::setNumeroRegistro()
     * @uses EnviarFactura::setOrganoGestor()
     * @uses EnviarFactura::setUnidadTramitadora()
     * @uses EnviarFactura::setOficinaContable()
     * @uses EnviarFactura::setIdentificadorEmisor()
     * @uses EnviarFactura::setNumeroFactura()
     * @uses EnviarFactura::setSerieFactura()
     * @uses EnviarFactura::setFechaRecepcion()
     * @param string $numeroRegistro
     * @param string $organoGestor
     * @param string $unidadTramitadora
     * @param string $oficinaContable
     * @param string $identificadorEmisor
     * @param string $numeroFactura
     * @param string $serieFactura
     * @param string $fechaRecepcion
     */
    public function __construct($numeroRegistro = null, $organoGestor = null, $unidadTramitadora = null, $oficinaContable = null, $identificadorEmisor = null, $numeroFactura = null, $serieFactura = null, $fechaRecepcion = null)
    {
        $this
            ->setNumeroRegistro($numeroRegistro)
            ->setOrganoGestor($organoGestor)
            ->setUnidadTramitadora($unidadTramitadora)
            ->setOficinaContable($oficinaContable)
            ->setIdentificadorEmisor($identificadorEmisor)
            ->setNumeroFactura($numeroFactura)
            ->setSerieFactura($serieFactura)
            ->setFechaRecepcion($fechaRecepcion);
    }
    /**
     * Get numeroRegistro value
     * @return string|null
     */
    public function getNumeroRegistro()
    {
        return $this->numeroRegistro;
    }
    /**
     * Set numeroRegistro value
     * @param string $numeroRegistro
     * @return \StructType\EnviarFactura
     */
    public function setNumeroRegistro($numeroRegistro = null)
    {
        // validation for constraint: string
        if (!is_null($numeroRegistro) && !is_string($numeroRegistro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroRegistro, true), gettype($numeroRegistro)), __LINE__);
        }
        $this->numeroRegistro = $numeroRegistro;
        return $this;
    }
    /**
     * Get organoGestor value
     * @return string|null
     */
    public function getOrganoGestor()
    {
        return $this->organoGestor;
    }
    /**
     * Set organoGestor value
     * @param string $organoGestor
     * @return \StructType\EnviarFactura
     */
    public function setOrganoGestor($organoGestor = null)
    {
        // validation for constraint: string
        if (!is_null($organoGestor) && !is_string($organoGestor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organoGestor, true), gettype($organoGestor)), __LINE__);
        }
        $this->organoGestor = $organoGestor;
        return $this;
    }
    /**
     * Get unidadTramitadora value
     * @return string|null
     */
    public function getUnidadTramitadora()
    {
        return $this->unidadTramitadora;
    }
    /**
     * Set unidadTramitadora value
     * @param string $unidadTramitadora
     * @return \StructType\EnviarFactura
     */
    public function setUnidadTramitadora($unidadTramitadora = null)
    {
        // validation for constraint: string
        if (!is_null($unidadTramitadora) && !is_string($unidadTramitadora)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unidadTramitadora, true), gettype($unidadTramitadora)), __LINE__);
        }
        $this->unidadTramitadora = $unidadTramitadora;
        return $this;
    }
    /**
     * Get oficinaContable value
     * @return string|null
     */
    public function getOficinaContable()
    {
        return $this->oficinaContable;
    }
    /**
     * Set oficinaContable value
     * @param string $oficinaContable
     * @return \StructType\EnviarFactura
     */
    public function setOficinaContable($oficinaContable = null)
    {
        // validation for constraint: string
        if (!is_null($oficinaContable) && !is_string($oficinaContable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oficinaContable, true), gettype($oficinaContable)), __LINE__);
        }
        $this->oficinaContable = $oficinaContable;
        return $this;
    }
    /**
     * Get identificadorEmisor value
     * @return string|null
     */
    public function getIdentificadorEmisor()
    {
        return $this->identificadorEmisor;
    }
    /**
     * Set identificadorEmisor value
     * @param string $identificadorEmisor
     * @return \StructType\EnviarFactura
     */
    public function setIdentificadorEmisor($identificadorEmisor = null)
    {
        // validation for constraint: string
        if (!is_null($identificadorEmisor) && !is_string($identificadorEmisor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificadorEmisor, true), gettype($identificadorEmisor)), __LINE__);
        }
        $this->identificadorEmisor = $identificadorEmisor;
        return $this;
    }
    /**
     * Get numeroFactura value
     * @return string|null
     */
    public function getNumeroFactura()
    {
        return $this->numeroFactura;
    }
    /**
     * Set numeroFactura value
     * @param string $numeroFactura
     * @return \StructType\EnviarFactura
     */
    public function setNumeroFactura($numeroFactura = null)
    {
        // validation for constraint: string
        if (!is_null($numeroFactura) && !is_string($numeroFactura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroFactura, true), gettype($numeroFactura)), __LINE__);
        }
        $this->numeroFactura = $numeroFactura;
        return $this;
    }
    /**
     * Get serieFactura value
     * @return string|null
     */
    public function getSerieFactura()
    {
        return $this->serieFactura;
    }
    /**
     * Set serieFactura value
     * @param string $serieFactura
     * @return \StructType\EnviarFactura
     */
    public function setSerieFactura($serieFactura = null)
    {
        // validation for constraint: string
        if (!is_null($serieFactura) && !is_string($serieFactura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serieFactura, true), gettype($serieFactura)), __LINE__);
        }
        $this->serieFactura = $serieFactura;
        return $this;
    }
    /**
     * Get fechaRecepcion value
     * @return string|null
     */
    public function getFechaRecepcion()
    {
        return $this->fechaRecepcion;
    }
    /**
     * Set fechaRecepcion value
     * @param string $fechaRecepcion
     * @return \StructType\EnviarFactura
     */
    public function setFechaRecepcion($fechaRecepcion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaRecepcion) && !is_string($fechaRecepcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaRecepcion, true), gettype($fechaRecepcion)), __LINE__);
        }
        $this->fechaRecepcion = $fechaRecepcion;
        return $this;
    }
}
