<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultarListadoFactura StructType
 * @subpackage Structs
 */
class ConsultarListadoFactura extends AbstractStructBase
{
    /**
     * The codigo
     * @var string
     */
    public $codigo;
    /**
     * The descripcion
     * @var string
     */
    public $descripcion;
    /**
     * The factura
     * @var \StructType\ConsultarFactura
     */
    public $factura;
    /**
     * Constructor method for ConsultarListadoFactura
     * @uses ConsultarListadoFactura::setCodigo()
     * @uses ConsultarListadoFactura::setDescripcion()
     * @uses ConsultarListadoFactura::setFactura()
     * @param string $codigo
     * @param string $descripcion
     * @param \StructType\ConsultarFactura $factura
     */
    public function __construct($codigo = null, $descripcion = null, \StructType\ConsultarFactura $factura = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDescripcion($descripcion)
            ->setFactura($factura);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\ConsultarListadoFactura
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get descripcion value
     * @return string|null
     */
    public function getDescripcion()
    {
        return $this->descripcion;
    }
    /**
     * Set descripcion value
     * @param string $descripcion
     * @return \StructType\ConsultarListadoFactura
     */
    public function setDescripcion($descripcion = null)
    {
        // validation for constraint: string
        if (!is_null($descripcion) && !is_string($descripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descripcion, true), gettype($descripcion)), __LINE__);
        }
        $this->descripcion = $descripcion;
        return $this;
    }
    /**
     * Get factura value
     * @return \StructType\ConsultarFactura|null
     */
    public function getFactura()
    {
        return $this->factura;
    }
    /**
     * Set factura value
     * @param \StructType\ConsultarFactura $factura
     * @return \StructType\ConsultarListadoFactura
     */
    public function setFactura(\StructType\ConsultarFactura $factura = null)
    {
        $this->factura = $factura;
        return $this;
    }
}
