<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnularFactura StructType
 * @subpackage Structs
 */
class AnularFactura extends AbstractStructBase
{
    /**
     * The numeroRegistro
     * @var string
     */
    public $numeroRegistro;
    /**
     * The mensaje
     * @var string
     */
    public $mensaje;
    /**
     * Constructor method for AnularFactura
     * @uses AnularFactura::setNumeroRegistro()
     * @uses AnularFactura::setMensaje()
     * @param string $numeroRegistro
     * @param string $mensaje
     */
    public function __construct($numeroRegistro = null, $mensaje = null)
    {
        $this
            ->setNumeroRegistro($numeroRegistro)
            ->setMensaje($mensaje);
    }
    /**
     * Get numeroRegistro value
     * @return string|null
     */
    public function getNumeroRegistro()
    {
        return $this->numeroRegistro;
    }
    /**
     * Set numeroRegistro value
     * @param string $numeroRegistro
     * @return \StructType\AnularFactura
     */
    public function setNumeroRegistro($numeroRegistro = null)
    {
        // validation for constraint: string
        if (!is_null($numeroRegistro) && !is_string($numeroRegistro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroRegistro, true), gettype($numeroRegistro)), __LINE__);
        }
        $this->numeroRegistro = $numeroRegistro;
        return $this;
    }
    /**
     * Get mensaje value
     * @return string|null
     */
    public function getMensaje()
    {
        return $this->mensaje;
    }
    /**
     * Set mensaje value
     * @param string $mensaje
     * @return \StructType\AnularFactura
     */
    public function setMensaje($mensaje = null)
    {
        // validation for constraint: string
        if (!is_null($mensaje) && !is_string($mensaje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensaje, true), gettype($mensaje)), __LINE__);
        }
        $this->mensaje = $mensaje;
        return $this;
    }
}
