<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Taxes StructType
 * @subpackage Structs
 */
class Taxes extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The CustomerTaxZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CustomerTaxZone;
    /**
     * The TaxID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxID;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxRate;
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxableAmount;
    /**
     * The ExemptedAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExemptedAmount;
    /**
     * The TaxUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxUOM;
    /**
     * The TaxableQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxableQty;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxAmount;
    /**
     * The TaxType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxType;
    /**
     * The PendingVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PendingVAT;
    /**
     * The ReverseVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReverseVAT;
    /**
     * The IncludeInVATExemptTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $IncludeInVATExemptTotal;
    /**
     * The StatisticalVAT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $StatisticalVAT;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TaxesServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Taxes
     * @uses Taxes::setDisplayName()
     * @uses Taxes::setCustomerTaxZone()
     * @uses Taxes::setTaxID()
     * @uses Taxes::setTaxRate()
     * @uses Taxes::setTaxableAmount()
     * @uses Taxes::setExemptedAmount()
     * @uses Taxes::setTaxUOM()
     * @uses Taxes::setTaxableQty()
     * @uses Taxes::setTaxAmount()
     * @uses Taxes::setTaxType()
     * @uses Taxes::setPendingVAT()
     * @uses Taxes::setReverseVAT()
     * @uses Taxes::setIncludeInVATExemptTotal()
     * @uses Taxes::setStatisticalVAT()
     * @uses Taxes::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $customerTaxZone
     * @param \StructType\Field $taxID
     * @param \StructType\Field $taxRate
     * @param \StructType\Field $taxableAmount
     * @param \StructType\Field $exemptedAmount
     * @param \StructType\Field $taxUOM
     * @param \StructType\Field $taxableQty
     * @param \StructType\Field $taxAmount
     * @param \StructType\Field $taxType
     * @param \StructType\Field $pendingVAT
     * @param \StructType\Field $reverseVAT
     * @param \StructType\Field $includeInVATExemptTotal
     * @param \StructType\Field $statisticalVAT
     * @param \StructType\TaxesServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $customerTaxZone = null, \StructType\Field $taxID = null, \StructType\Field $taxRate = null, \StructType\Field $taxableAmount = null, \StructType\Field $exemptedAmount = null, \StructType\Field $taxUOM = null, \StructType\Field $taxableQty = null, \StructType\Field $taxAmount = null, \StructType\Field $taxType = null, \StructType\Field $pendingVAT = null, \StructType\Field $reverseVAT = null, \StructType\Field $includeInVATExemptTotal = null, \StructType\Field $statisticalVAT = null, \StructType\TaxesServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setCustomerTaxZone($customerTaxZone)
            ->setTaxID($taxID)
            ->setTaxRate($taxRate)
            ->setTaxableAmount($taxableAmount)
            ->setExemptedAmount($exemptedAmount)
            ->setTaxUOM($taxUOM)
            ->setTaxableQty($taxableQty)
            ->setTaxAmount($taxAmount)
            ->setTaxType($taxType)
            ->setPendingVAT($pendingVAT)
            ->setReverseVAT($reverseVAT)
            ->setIncludeInVATExemptTotal($includeInVATExemptTotal)
            ->setStatisticalVAT($statisticalVAT)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Taxes
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get CustomerTaxZone value
     * @return \StructType\Field|null
     */
    public function getCustomerTaxZone()
    {
        return $this->CustomerTaxZone;
    }
    /**
     * Set CustomerTaxZone value
     * @param \StructType\Field $customerTaxZone
     * @return \StructType\Taxes
     */
    public function setCustomerTaxZone(\StructType\Field $customerTaxZone = null)
    {
        $this->CustomerTaxZone = $customerTaxZone;
        return $this;
    }
    /**
     * Get TaxID value
     * @return \StructType\Field|null
     */
    public function getTaxID()
    {
        return $this->TaxID;
    }
    /**
     * Set TaxID value
     * @param \StructType\Field $taxID
     * @return \StructType\Taxes
     */
    public function setTaxID(\StructType\Field $taxID = null)
    {
        $this->TaxID = $taxID;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return \StructType\Field|null
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param \StructType\Field $taxRate
     * @return \StructType\Taxes
     */
    public function setTaxRate(\StructType\Field $taxRate = null)
    {
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get TaxableAmount value
     * @return \StructType\Field|null
     */
    public function getTaxableAmount()
    {
        return $this->TaxableAmount;
    }
    /**
     * Set TaxableAmount value
     * @param \StructType\Field $taxableAmount
     * @return \StructType\Taxes
     */
    public function setTaxableAmount(\StructType\Field $taxableAmount = null)
    {
        $this->TaxableAmount = $taxableAmount;
        return $this;
    }
    /**
     * Get ExemptedAmount value
     * @return \StructType\Field|null
     */
    public function getExemptedAmount()
    {
        return $this->ExemptedAmount;
    }
    /**
     * Set ExemptedAmount value
     * @param \StructType\Field $exemptedAmount
     * @return \StructType\Taxes
     */
    public function setExemptedAmount(\StructType\Field $exemptedAmount = null)
    {
        $this->ExemptedAmount = $exemptedAmount;
        return $this;
    }
    /**
     * Get TaxUOM value
     * @return \StructType\Field|null
     */
    public function getTaxUOM()
    {
        return $this->TaxUOM;
    }
    /**
     * Set TaxUOM value
     * @param \StructType\Field $taxUOM
     * @return \StructType\Taxes
     */
    public function setTaxUOM(\StructType\Field $taxUOM = null)
    {
        $this->TaxUOM = $taxUOM;
        return $this;
    }
    /**
     * Get TaxableQty value
     * @return \StructType\Field|null
     */
    public function getTaxableQty()
    {
        return $this->TaxableQty;
    }
    /**
     * Set TaxableQty value
     * @param \StructType\Field $taxableQty
     * @return \StructType\Taxes
     */
    public function setTaxableQty(\StructType\Field $taxableQty = null)
    {
        $this->TaxableQty = $taxableQty;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return \StructType\Field|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param \StructType\Field $taxAmount
     * @return \StructType\Taxes
     */
    public function setTaxAmount(\StructType\Field $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TaxType value
     * @return \StructType\Field|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @param \StructType\Field $taxType
     * @return \StructType\Taxes
     */
    public function setTaxType(\StructType\Field $taxType = null)
    {
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Get PendingVAT value
     * @return \StructType\Field|null
     */
    public function getPendingVAT()
    {
        return $this->PendingVAT;
    }
    /**
     * Set PendingVAT value
     * @param \StructType\Field $pendingVAT
     * @return \StructType\Taxes
     */
    public function setPendingVAT(\StructType\Field $pendingVAT = null)
    {
        $this->PendingVAT = $pendingVAT;
        return $this;
    }
    /**
     * Get ReverseVAT value
     * @return \StructType\Field|null
     */
    public function getReverseVAT()
    {
        return $this->ReverseVAT;
    }
    /**
     * Set ReverseVAT value
     * @param \StructType\Field $reverseVAT
     * @return \StructType\Taxes
     */
    public function setReverseVAT(\StructType\Field $reverseVAT = null)
    {
        $this->ReverseVAT = $reverseVAT;
        return $this;
    }
    /**
     * Get IncludeInVATExemptTotal value
     * @return \StructType\Field|null
     */
    public function getIncludeInVATExemptTotal()
    {
        return $this->IncludeInVATExemptTotal;
    }
    /**
     * Set IncludeInVATExemptTotal value
     * @param \StructType\Field $includeInVATExemptTotal
     * @return \StructType\Taxes
     */
    public function setIncludeInVATExemptTotal(\StructType\Field $includeInVATExemptTotal = null)
    {
        $this->IncludeInVATExemptTotal = $includeInVATExemptTotal;
        return $this;
    }
    /**
     * Get StatisticalVAT value
     * @return \StructType\Field|null
     */
    public function getStatisticalVAT()
    {
        return $this->StatisticalVAT;
    }
    /**
     * Set StatisticalVAT value
     * @param \StructType\Field $statisticalVAT
     * @return \StructType\Taxes
     */
    public function setStatisticalVAT(\StructType\Field $statisticalVAT = null)
    {
        $this->StatisticalVAT = $statisticalVAT;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\TaxesServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\TaxesServiceCommands $serviceCommands
     * @return \StructType\Taxes
     */
    public function setServiceCommands(\StructType\TaxesServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
