<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShippingDeliverySettings StructType
 * @subpackage Structs
 */
class ShippingDeliverySettings extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The ShipVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipVia;
    /**
     * The WillCall
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $WillCall;
    /**
     * The DeliveryConfirmation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DeliveryConfirmation;
    /**
     * The Endorsement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Endorsement;
    /**
     * The FreightClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FreightClass;
    /**
     * The FOBPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FOBPoint;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Priority;
    /**
     * The ShippingTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippingTerms;
    /**
     * The ShippingZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippingZone;
    /**
     * The ResidentialDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ResidentialDelivery;
    /**
     * The SaturdayDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SaturdayDelivery;
    /**
     * The Insurance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Insurance;
    /**
     * The UseCustomerSAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UseCustomerSAccount;
    /**
     * The GroundCollect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $GroundCollect;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShippingDeliverySettingsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ShippingDeliverySettings
     * @uses ShippingDeliverySettings::setDisplayName()
     * @uses ShippingDeliverySettings::setShipVia()
     * @uses ShippingDeliverySettings::setWillCall()
     * @uses ShippingDeliverySettings::setDeliveryConfirmation()
     * @uses ShippingDeliverySettings::setEndorsement()
     * @uses ShippingDeliverySettings::setFreightClass()
     * @uses ShippingDeliverySettings::setFOBPoint()
     * @uses ShippingDeliverySettings::setPriority()
     * @uses ShippingDeliverySettings::setShippingTerms()
     * @uses ShippingDeliverySettings::setShippingZone()
     * @uses ShippingDeliverySettings::setResidentialDelivery()
     * @uses ShippingDeliverySettings::setSaturdayDelivery()
     * @uses ShippingDeliverySettings::setInsurance()
     * @uses ShippingDeliverySettings::setUseCustomerSAccount()
     * @uses ShippingDeliverySettings::setGroundCollect()
     * @uses ShippingDeliverySettings::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $shipVia
     * @param \StructType\Field $willCall
     * @param \StructType\Field $deliveryConfirmation
     * @param \StructType\Field $endorsement
     * @param \StructType\Field $freightClass
     * @param \StructType\Field $fOBPoint
     * @param \StructType\Field $priority
     * @param \StructType\Field $shippingTerms
     * @param \StructType\Field $shippingZone
     * @param \StructType\Field $residentialDelivery
     * @param \StructType\Field $saturdayDelivery
     * @param \StructType\Field $insurance
     * @param \StructType\Field $useCustomerSAccount
     * @param \StructType\Field $groundCollect
     * @param \StructType\ShippingDeliverySettingsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $shipVia = null, \StructType\Field $willCall = null, \StructType\Field $deliveryConfirmation = null, \StructType\Field $endorsement = null, \StructType\Field $freightClass = null, \StructType\Field $fOBPoint = null, \StructType\Field $priority = null, \StructType\Field $shippingTerms = null, \StructType\Field $shippingZone = null, \StructType\Field $residentialDelivery = null, \StructType\Field $saturdayDelivery = null, \StructType\Field $insurance = null, \StructType\Field $useCustomerSAccount = null, \StructType\Field $groundCollect = null, \StructType\ShippingDeliverySettingsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setShipVia($shipVia)
            ->setWillCall($willCall)
            ->setDeliveryConfirmation($deliveryConfirmation)
            ->setEndorsement($endorsement)
            ->setFreightClass($freightClass)
            ->setFOBPoint($fOBPoint)
            ->setPriority($priority)
            ->setShippingTerms($shippingTerms)
            ->setShippingZone($shippingZone)
            ->setResidentialDelivery($residentialDelivery)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setInsurance($insurance)
            ->setUseCustomerSAccount($useCustomerSAccount)
            ->setGroundCollect($groundCollect)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ShippingDeliverySettings
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get ShipVia value
     * @return \StructType\Field|null
     */
    public function getShipVia()
    {
        return $this->ShipVia;
    }
    /**
     * Set ShipVia value
     * @param \StructType\Field $shipVia
     * @return \StructType\ShippingDeliverySettings
     */
    public function setShipVia(\StructType\Field $shipVia = null)
    {
        $this->ShipVia = $shipVia;
        return $this;
    }
    /**
     * Get WillCall value
     * @return \StructType\Field|null
     */
    public function getWillCall()
    {
        return $this->WillCall;
    }
    /**
     * Set WillCall value
     * @param \StructType\Field $willCall
     * @return \StructType\ShippingDeliverySettings
     */
    public function setWillCall(\StructType\Field $willCall = null)
    {
        $this->WillCall = $willCall;
        return $this;
    }
    /**
     * Get DeliveryConfirmation value
     * @return \StructType\Field|null
     */
    public function getDeliveryConfirmation()
    {
        return $this->DeliveryConfirmation;
    }
    /**
     * Set DeliveryConfirmation value
     * @param \StructType\Field $deliveryConfirmation
     * @return \StructType\ShippingDeliverySettings
     */
    public function setDeliveryConfirmation(\StructType\Field $deliveryConfirmation = null)
    {
        $this->DeliveryConfirmation = $deliveryConfirmation;
        return $this;
    }
    /**
     * Get Endorsement value
     * @return \StructType\Field|null
     */
    public function getEndorsement()
    {
        return $this->Endorsement;
    }
    /**
     * Set Endorsement value
     * @param \StructType\Field $endorsement
     * @return \StructType\ShippingDeliverySettings
     */
    public function setEndorsement(\StructType\Field $endorsement = null)
    {
        $this->Endorsement = $endorsement;
        return $this;
    }
    /**
     * Get FreightClass value
     * @return \StructType\Field|null
     */
    public function getFreightClass()
    {
        return $this->FreightClass;
    }
    /**
     * Set FreightClass value
     * @param \StructType\Field $freightClass
     * @return \StructType\ShippingDeliverySettings
     */
    public function setFreightClass(\StructType\Field $freightClass = null)
    {
        $this->FreightClass = $freightClass;
        return $this;
    }
    /**
     * Get FOBPoint value
     * @return \StructType\Field|null
     */
    public function getFOBPoint()
    {
        return $this->FOBPoint;
    }
    /**
     * Set FOBPoint value
     * @param \StructType\Field $fOBPoint
     * @return \StructType\ShippingDeliverySettings
     */
    public function setFOBPoint(\StructType\Field $fOBPoint = null)
    {
        $this->FOBPoint = $fOBPoint;
        return $this;
    }
    /**
     * Get Priority value
     * @return \StructType\Field|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param \StructType\Field $priority
     * @return \StructType\ShippingDeliverySettings
     */
    public function setPriority(\StructType\Field $priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get ShippingTerms value
     * @return \StructType\Field|null
     */
    public function getShippingTerms()
    {
        return $this->ShippingTerms;
    }
    /**
     * Set ShippingTerms value
     * @param \StructType\Field $shippingTerms
     * @return \StructType\ShippingDeliverySettings
     */
    public function setShippingTerms(\StructType\Field $shippingTerms = null)
    {
        $this->ShippingTerms = $shippingTerms;
        return $this;
    }
    /**
     * Get ShippingZone value
     * @return \StructType\Field|null
     */
    public function getShippingZone()
    {
        return $this->ShippingZone;
    }
    /**
     * Set ShippingZone value
     * @param \StructType\Field $shippingZone
     * @return \StructType\ShippingDeliverySettings
     */
    public function setShippingZone(\StructType\Field $shippingZone = null)
    {
        $this->ShippingZone = $shippingZone;
        return $this;
    }
    /**
     * Get ResidentialDelivery value
     * @return \StructType\Field|null
     */
    public function getResidentialDelivery()
    {
        return $this->ResidentialDelivery;
    }
    /**
     * Set ResidentialDelivery value
     * @param \StructType\Field $residentialDelivery
     * @return \StructType\ShippingDeliverySettings
     */
    public function setResidentialDelivery(\StructType\Field $residentialDelivery = null)
    {
        $this->ResidentialDelivery = $residentialDelivery;
        return $this;
    }
    /**
     * Get SaturdayDelivery value
     * @return \StructType\Field|null
     */
    public function getSaturdayDelivery()
    {
        return $this->SaturdayDelivery;
    }
    /**
     * Set SaturdayDelivery value
     * @param \StructType\Field $saturdayDelivery
     * @return \StructType\ShippingDeliverySettings
     */
    public function setSaturdayDelivery(\StructType\Field $saturdayDelivery = null)
    {
        $this->SaturdayDelivery = $saturdayDelivery;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \StructType\Field|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param \StructType\Field $insurance
     * @return \StructType\ShippingDeliverySettings
     */
    public function setInsurance(\StructType\Field $insurance = null)
    {
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get UseCustomerSAccount value
     * @return \StructType\Field|null
     */
    public function getUseCustomerSAccount()
    {
        return $this->UseCustomerSAccount;
    }
    /**
     * Set UseCustomerSAccount value
     * @param \StructType\Field $useCustomerSAccount
     * @return \StructType\ShippingDeliverySettings
     */
    public function setUseCustomerSAccount(\StructType\Field $useCustomerSAccount = null)
    {
        $this->UseCustomerSAccount = $useCustomerSAccount;
        return $this;
    }
    /**
     * Get GroundCollect value
     * @return \StructType\Field|null
     */
    public function getGroundCollect()
    {
        return $this->GroundCollect;
    }
    /**
     * Set GroundCollect value
     * @param \StructType\Field $groundCollect
     * @return \StructType\ShippingDeliverySettings
     */
    public function setGroundCollect(\StructType\Field $groundCollect = null)
    {
        $this->GroundCollect = $groundCollect;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ShippingDeliverySettingsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ShippingDeliverySettingsServiceCommands $serviceCommands
     * @return \StructType\ShippingDeliverySettings
     */
    public function setServiceCommands(\StructType\ShippingDeliverySettingsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
