<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductionOrders StructType
 * @subpackage Structs
 */
class ProductionOrders extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The AMSelected
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AMSelected;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineNbr;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryID;
    /**
     * The SubItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SubItemID;
    /**
     * The AMQtyReadOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AMQtyReadOnly;
    /**
     * The AMUOMReadOnly
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AMUOMReadOnly;
    /**
     * The AMorderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AMorderType;
    /**
     * The AMProdOrdID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AMProdOrdID;
    /**
     * The AMProdItemStatusID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AMProdItemStatusID;
    /**
     * The AMProdItemQtytoProd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AMProdItemQtytoProd;
    /**
     * The AMProdItemQtyComplete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AMProdItemQtyComplete;
    /**
     * The AMProdItemUOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AMProdItemUOM;
    /**
     * The AMConfigurationResultsCompleted
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AMConfigurationResultsCompleted;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductionOrdersServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ProductionOrders
     * @uses ProductionOrders::setDisplayName()
     * @uses ProductionOrders::setAMSelected()
     * @uses ProductionOrders::setLineNbr()
     * @uses ProductionOrders::setInventoryID()
     * @uses ProductionOrders::setSubItemID()
     * @uses ProductionOrders::setAMQtyReadOnly()
     * @uses ProductionOrders::setAMUOMReadOnly()
     * @uses ProductionOrders::setAMorderType()
     * @uses ProductionOrders::setAMProdOrdID()
     * @uses ProductionOrders::setAMProdItemStatusID()
     * @uses ProductionOrders::setAMProdItemQtytoProd()
     * @uses ProductionOrders::setAMProdItemQtyComplete()
     * @uses ProductionOrders::setAMProdItemUOM()
     * @uses ProductionOrders::setAMConfigurationResultsCompleted()
     * @uses ProductionOrders::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $aMSelected
     * @param \StructType\Field $lineNbr
     * @param \StructType\Field $inventoryID
     * @param \StructType\Field $subItemID
     * @param \StructType\Field $aMQtyReadOnly
     * @param \StructType\Field $aMUOMReadOnly
     * @param \StructType\Field $aMorderType
     * @param \StructType\Field $aMProdOrdID
     * @param \StructType\Field $aMProdItemStatusID
     * @param \StructType\Field $aMProdItemQtytoProd
     * @param \StructType\Field $aMProdItemQtyComplete
     * @param \StructType\Field $aMProdItemUOM
     * @param \StructType\Field $aMConfigurationResultsCompleted
     * @param \StructType\ProductionOrdersServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $aMSelected = null, \StructType\Field $lineNbr = null, \StructType\Field $inventoryID = null, \StructType\Field $subItemID = null, \StructType\Field $aMQtyReadOnly = null, \StructType\Field $aMUOMReadOnly = null, \StructType\Field $aMorderType = null, \StructType\Field $aMProdOrdID = null, \StructType\Field $aMProdItemStatusID = null, \StructType\Field $aMProdItemQtytoProd = null, \StructType\Field $aMProdItemQtyComplete = null, \StructType\Field $aMProdItemUOM = null, \StructType\Field $aMConfigurationResultsCompleted = null, \StructType\ProductionOrdersServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setAMSelected($aMSelected)
            ->setLineNbr($lineNbr)
            ->setInventoryID($inventoryID)
            ->setSubItemID($subItemID)
            ->setAMQtyReadOnly($aMQtyReadOnly)
            ->setAMUOMReadOnly($aMUOMReadOnly)
            ->setAMorderType($aMorderType)
            ->setAMProdOrdID($aMProdOrdID)
            ->setAMProdItemStatusID($aMProdItemStatusID)
            ->setAMProdItemQtytoProd($aMProdItemQtytoProd)
            ->setAMProdItemQtyComplete($aMProdItemQtyComplete)
            ->setAMProdItemUOM($aMProdItemUOM)
            ->setAMConfigurationResultsCompleted($aMConfigurationResultsCompleted)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ProductionOrders
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get AMSelected value
     * @return \StructType\Field|null
     */
    public function getAMSelected()
    {
        return $this->AMSelected;
    }
    /**
     * Set AMSelected value
     * @param \StructType\Field $aMSelected
     * @return \StructType\ProductionOrders
     */
    public function setAMSelected(\StructType\Field $aMSelected = null)
    {
        $this->AMSelected = $aMSelected;
        return $this;
    }
    /**
     * Get LineNbr value
     * @return \StructType\Field|null
     */
    public function getLineNbr()
    {
        return $this->LineNbr;
    }
    /**
     * Set LineNbr value
     * @param \StructType\Field $lineNbr
     * @return \StructType\ProductionOrders
     */
    public function setLineNbr(\StructType\Field $lineNbr = null)
    {
        $this->LineNbr = $lineNbr;
        return $this;
    }
    /**
     * Get InventoryID value
     * @return \StructType\Field|null
     */
    public function getInventoryID()
    {
        return $this->InventoryID;
    }
    /**
     * Set InventoryID value
     * @param \StructType\Field $inventoryID
     * @return \StructType\ProductionOrders
     */
    public function setInventoryID(\StructType\Field $inventoryID = null)
    {
        $this->InventoryID = $inventoryID;
        return $this;
    }
    /**
     * Get SubItemID value
     * @return \StructType\Field|null
     */
    public function getSubItemID()
    {
        return $this->SubItemID;
    }
    /**
     * Set SubItemID value
     * @param \StructType\Field $subItemID
     * @return \StructType\ProductionOrders
     */
    public function setSubItemID(\StructType\Field $subItemID = null)
    {
        $this->SubItemID = $subItemID;
        return $this;
    }
    /**
     * Get AMQtyReadOnly value
     * @return \StructType\Field|null
     */
    public function getAMQtyReadOnly()
    {
        return $this->AMQtyReadOnly;
    }
    /**
     * Set AMQtyReadOnly value
     * @param \StructType\Field $aMQtyReadOnly
     * @return \StructType\ProductionOrders
     */
    public function setAMQtyReadOnly(\StructType\Field $aMQtyReadOnly = null)
    {
        $this->AMQtyReadOnly = $aMQtyReadOnly;
        return $this;
    }
    /**
     * Get AMUOMReadOnly value
     * @return \StructType\Field|null
     */
    public function getAMUOMReadOnly()
    {
        return $this->AMUOMReadOnly;
    }
    /**
     * Set AMUOMReadOnly value
     * @param \StructType\Field $aMUOMReadOnly
     * @return \StructType\ProductionOrders
     */
    public function setAMUOMReadOnly(\StructType\Field $aMUOMReadOnly = null)
    {
        $this->AMUOMReadOnly = $aMUOMReadOnly;
        return $this;
    }
    /**
     * Get AMorderType value
     * @return \StructType\Field|null
     */
    public function getAMorderType()
    {
        return $this->AMorderType;
    }
    /**
     * Set AMorderType value
     * @param \StructType\Field $aMorderType
     * @return \StructType\ProductionOrders
     */
    public function setAMorderType(\StructType\Field $aMorderType = null)
    {
        $this->AMorderType = $aMorderType;
        return $this;
    }
    /**
     * Get AMProdOrdID value
     * @return \StructType\Field|null
     */
    public function getAMProdOrdID()
    {
        return $this->AMProdOrdID;
    }
    /**
     * Set AMProdOrdID value
     * @param \StructType\Field $aMProdOrdID
     * @return \StructType\ProductionOrders
     */
    public function setAMProdOrdID(\StructType\Field $aMProdOrdID = null)
    {
        $this->AMProdOrdID = $aMProdOrdID;
        return $this;
    }
    /**
     * Get AMProdItemStatusID value
     * @return \StructType\Field|null
     */
    public function getAMProdItemStatusID()
    {
        return $this->AMProdItemStatusID;
    }
    /**
     * Set AMProdItemStatusID value
     * @param \StructType\Field $aMProdItemStatusID
     * @return \StructType\ProductionOrders
     */
    public function setAMProdItemStatusID(\StructType\Field $aMProdItemStatusID = null)
    {
        $this->AMProdItemStatusID = $aMProdItemStatusID;
        return $this;
    }
    /**
     * Get AMProdItemQtytoProd value
     * @return \StructType\Field|null
     */
    public function getAMProdItemQtytoProd()
    {
        return $this->AMProdItemQtytoProd;
    }
    /**
     * Set AMProdItemQtytoProd value
     * @param \StructType\Field $aMProdItemQtytoProd
     * @return \StructType\ProductionOrders
     */
    public function setAMProdItemQtytoProd(\StructType\Field $aMProdItemQtytoProd = null)
    {
        $this->AMProdItemQtytoProd = $aMProdItemQtytoProd;
        return $this;
    }
    /**
     * Get AMProdItemQtyComplete value
     * @return \StructType\Field|null
     */
    public function getAMProdItemQtyComplete()
    {
        return $this->AMProdItemQtyComplete;
    }
    /**
     * Set AMProdItemQtyComplete value
     * @param \StructType\Field $aMProdItemQtyComplete
     * @return \StructType\ProductionOrders
     */
    public function setAMProdItemQtyComplete(\StructType\Field $aMProdItemQtyComplete = null)
    {
        $this->AMProdItemQtyComplete = $aMProdItemQtyComplete;
        return $this;
    }
    /**
     * Get AMProdItemUOM value
     * @return \StructType\Field|null
     */
    public function getAMProdItemUOM()
    {
        return $this->AMProdItemUOM;
    }
    /**
     * Set AMProdItemUOM value
     * @param \StructType\Field $aMProdItemUOM
     * @return \StructType\ProductionOrders
     */
    public function setAMProdItemUOM(\StructType\Field $aMProdItemUOM = null)
    {
        $this->AMProdItemUOM = $aMProdItemUOM;
        return $this;
    }
    /**
     * Get AMConfigurationResultsCompleted value
     * @return \StructType\Field|null
     */
    public function getAMConfigurationResultsCompleted()
    {
        return $this->AMConfigurationResultsCompleted;
    }
    /**
     * Set AMConfigurationResultsCompleted value
     * @param \StructType\Field $aMConfigurationResultsCompleted
     * @return \StructType\ProductionOrders
     */
    public function setAMConfigurationResultsCompleted(\StructType\Field $aMConfigurationResultsCompleted = null)
    {
        $this->AMConfigurationResultsCompleted = $aMConfigurationResultsCompleted;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ProductionOrdersServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ProductionOrdersServiceCommands $serviceCommands
     * @return \StructType\ProductionOrders
     */
    public function setServiceCommands(\StructType\ProductionOrdersServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
