<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessOrderAvailability StructType
 * @subpackage Structs
 */
class ProcessOrderAvailability extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The GreenStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $GreenStatus;
    /**
     * The YellowStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $YellowStatus;
    /**
     * The RedStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RedStatus;
    /**
     * The AvailabilityMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AvailabilityMessage;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProcessOrderAvailabilityServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ProcessOrderAvailability
     * @uses ProcessOrderAvailability::setDisplayName()
     * @uses ProcessOrderAvailability::setGreenStatus()
     * @uses ProcessOrderAvailability::setYellowStatus()
     * @uses ProcessOrderAvailability::setRedStatus()
     * @uses ProcessOrderAvailability::setAvailabilityMessage()
     * @uses ProcessOrderAvailability::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $greenStatus
     * @param \StructType\Field $yellowStatus
     * @param \StructType\Field $redStatus
     * @param \StructType\Field $availabilityMessage
     * @param \StructType\ProcessOrderAvailabilityServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $greenStatus = null, \StructType\Field $yellowStatus = null, \StructType\Field $redStatus = null, \StructType\Field $availabilityMessage = null, \StructType\ProcessOrderAvailabilityServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setGreenStatus($greenStatus)
            ->setYellowStatus($yellowStatus)
            ->setRedStatus($redStatus)
            ->setAvailabilityMessage($availabilityMessage)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ProcessOrderAvailability
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get GreenStatus value
     * @return \StructType\Field|null
     */
    public function getGreenStatus()
    {
        return $this->GreenStatus;
    }
    /**
     * Set GreenStatus value
     * @param \StructType\Field $greenStatus
     * @return \StructType\ProcessOrderAvailability
     */
    public function setGreenStatus(\StructType\Field $greenStatus = null)
    {
        $this->GreenStatus = $greenStatus;
        return $this;
    }
    /**
     * Get YellowStatus value
     * @return \StructType\Field|null
     */
    public function getYellowStatus()
    {
        return $this->YellowStatus;
    }
    /**
     * Set YellowStatus value
     * @param \StructType\Field $yellowStatus
     * @return \StructType\ProcessOrderAvailability
     */
    public function setYellowStatus(\StructType\Field $yellowStatus = null)
    {
        $this->YellowStatus = $yellowStatus;
        return $this;
    }
    /**
     * Get RedStatus value
     * @return \StructType\Field|null
     */
    public function getRedStatus()
    {
        return $this->RedStatus;
    }
    /**
     * Set RedStatus value
     * @param \StructType\Field $redStatus
     * @return \StructType\ProcessOrderAvailability
     */
    public function setRedStatus(\StructType\Field $redStatus = null)
    {
        $this->RedStatus = $redStatus;
        return $this;
    }
    /**
     * Get AvailabilityMessage value
     * @return \StructType\Field|null
     */
    public function getAvailabilityMessage()
    {
        return $this->AvailabilityMessage;
    }
    /**
     * Set AvailabilityMessage value
     * @param \StructType\Field $availabilityMessage
     * @return \StructType\ProcessOrderAvailability
     */
    public function setAvailabilityMessage(\StructType\Field $availabilityMessage = null)
    {
        $this->AvailabilityMessage = $availabilityMessage;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ProcessOrderAvailabilityServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ProcessOrderAvailabilityServiceCommands $serviceCommands
     * @return \StructType\ProcessOrderAvailability
     */
    public function setServiceCommands(\StructType\ProcessOrderAvailabilityServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
