<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineDetailsUnassignedQty StructType
 * @subpackage Structs
 */
class LineDetailsUnassignedQty extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The UnassignedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnassignedQty;
    /**
     * The QuantityToGenerate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QuantityToGenerate;
    /**
     * The StartLotSerialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $StartLotSerialNumber;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LineDetailsUnassignedQtyServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for LineDetailsUnassignedQty
     * @uses LineDetailsUnassignedQty::setDisplayName()
     * @uses LineDetailsUnassignedQty::setUnassignedQty()
     * @uses LineDetailsUnassignedQty::setQuantityToGenerate()
     * @uses LineDetailsUnassignedQty::setStartLotSerialNumber()
     * @uses LineDetailsUnassignedQty::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $unassignedQty
     * @param \StructType\Field $quantityToGenerate
     * @param \StructType\Field $startLotSerialNumber
     * @param \StructType\LineDetailsUnassignedQtyServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $unassignedQty = null, \StructType\Field $quantityToGenerate = null, \StructType\Field $startLotSerialNumber = null, \StructType\LineDetailsUnassignedQtyServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setUnassignedQty($unassignedQty)
            ->setQuantityToGenerate($quantityToGenerate)
            ->setStartLotSerialNumber($startLotSerialNumber)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\LineDetailsUnassignedQty
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get UnassignedQty value
     * @return \StructType\Field|null
     */
    public function getUnassignedQty()
    {
        return $this->UnassignedQty;
    }
    /**
     * Set UnassignedQty value
     * @param \StructType\Field $unassignedQty
     * @return \StructType\LineDetailsUnassignedQty
     */
    public function setUnassignedQty(\StructType\Field $unassignedQty = null)
    {
        $this->UnassignedQty = $unassignedQty;
        return $this;
    }
    /**
     * Get QuantityToGenerate value
     * @return \StructType\Field|null
     */
    public function getQuantityToGenerate()
    {
        return $this->QuantityToGenerate;
    }
    /**
     * Set QuantityToGenerate value
     * @param \StructType\Field $quantityToGenerate
     * @return \StructType\LineDetailsUnassignedQty
     */
    public function setQuantityToGenerate(\StructType\Field $quantityToGenerate = null)
    {
        $this->QuantityToGenerate = $quantityToGenerate;
        return $this;
    }
    /**
     * Get StartLotSerialNumber value
     * @return \StructType\Field|null
     */
    public function getStartLotSerialNumber()
    {
        return $this->StartLotSerialNumber;
    }
    /**
     * Set StartLotSerialNumber value
     * @param \StructType\Field $startLotSerialNumber
     * @return \StructType\LineDetailsUnassignedQty
     */
    public function setStartLotSerialNumber(\StructType\Field $startLotSerialNumber = null)
    {
        $this->StartLotSerialNumber = $startLotSerialNumber;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\LineDetailsUnassignedQtyServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\LineDetailsUnassignedQtyServiceCommands $serviceCommands
     * @return \StructType\LineDetailsUnassignedQty
     */
    public function setServiceCommands(\StructType\LineDetailsUnassignedQtyServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
