<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Action StructType
 * @subpackage Structs
 */
class Action extends Command
{
    /**
     * The ViewTypeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ViewTypeName;
    /**
     * Constructor method for Action
     * @uses Action::setViewTypeName()
     * @param string $viewTypeName
     */
    public function __construct($viewTypeName = null)
    {
        $this
            ->setViewTypeName($viewTypeName);
    }
    /**
     * Get ViewTypeName value
     * @return string|null
     */
    public function getViewTypeName()
    {
        return $this->ViewTypeName;
    }
    /**
     * Set ViewTypeName value
     * @param string $viewTypeName
     * @return \StructType\Action
     */
    public function setViewTypeName($viewTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($viewTypeName) && !is_string($viewTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewTypeName, true), gettype($viewTypeName)), __LINE__);
        }
        $this->ViewTypeName = $viewTypeName;
        return $this;
    }
}
