<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ErrorCode EnumType
 * @subpackage Enumerations
 */
class ErrorCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'INVALID_CREDENTIALS'
     * @return string 'INVALID_CREDENTIALS'
     */
    const VALUE_INVALID_CREDENTIALS = 'INVALID_CREDENTIALS';
    /**
     * Constant for value 'INTERNAL_ERROR'
     * @return string 'INTERNAL_ERROR'
     */
    const VALUE_INTERNAL_ERROR = 'INTERNAL_ERROR';
    /**
     * Constant for value 'INVALID_API_VERSION'
     * @return string 'INVALID_API_VERSION'
     */
    const VALUE_INVALID_API_VERSION = 'INVALID_API_VERSION';
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_INVALID_CREDENTIALS
     * @uses self::VALUE_INTERNAL_ERROR
     * @uses self::VALUE_INVALID_API_VERSION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_INVALID_CREDENTIALS,
            self::VALUE_INTERNAL_ERROR,
            self::VALUE_INVALID_API_VERSION,
        );
    }
}
