<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessOrderShipping StructType
 * @subpackage Structs
 */
class ProcessOrderShipping extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The CreateShipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CreateShipment;
    /**
     * The PrintPickList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PrintPickList;
    /**
     * The ConfirmShipment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ConfirmShipment;
    /**
     * The PrintLabels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PrintLabels;
    /**
     * The PrintShipmentConfirmation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PrintShipmentConfirmation;
    /**
     * The UpdateIN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UpdateIN;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProcessOrderShippingServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ProcessOrderShipping
     * @uses ProcessOrderShipping::setDisplayName()
     * @uses ProcessOrderShipping::setCreateShipment()
     * @uses ProcessOrderShipping::setPrintPickList()
     * @uses ProcessOrderShipping::setConfirmShipment()
     * @uses ProcessOrderShipping::setPrintLabels()
     * @uses ProcessOrderShipping::setPrintShipmentConfirmation()
     * @uses ProcessOrderShipping::setUpdateIN()
     * @uses ProcessOrderShipping::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $createShipment
     * @param \StructType\Field $printPickList
     * @param \StructType\Field $confirmShipment
     * @param \StructType\Field $printLabels
     * @param \StructType\Field $printShipmentConfirmation
     * @param \StructType\Field $updateIN
     * @param \StructType\ProcessOrderShippingServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $createShipment = null, \StructType\Field $printPickList = null, \StructType\Field $confirmShipment = null, \StructType\Field $printLabels = null, \StructType\Field $printShipmentConfirmation = null, \StructType\Field $updateIN = null, \StructType\ProcessOrderShippingServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setCreateShipment($createShipment)
            ->setPrintPickList($printPickList)
            ->setConfirmShipment($confirmShipment)
            ->setPrintLabels($printLabels)
            ->setPrintShipmentConfirmation($printShipmentConfirmation)
            ->setUpdateIN($updateIN)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ProcessOrderShipping
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get CreateShipment value
     * @return \StructType\Field|null
     */
    public function getCreateShipment()
    {
        return $this->CreateShipment;
    }
    /**
     * Set CreateShipment value
     * @param \StructType\Field $createShipment
     * @return \StructType\ProcessOrderShipping
     */
    public function setCreateShipment(\StructType\Field $createShipment = null)
    {
        $this->CreateShipment = $createShipment;
        return $this;
    }
    /**
     * Get PrintPickList value
     * @return \StructType\Field|null
     */
    public function getPrintPickList()
    {
        return $this->PrintPickList;
    }
    /**
     * Set PrintPickList value
     * @param \StructType\Field $printPickList
     * @return \StructType\ProcessOrderShipping
     */
    public function setPrintPickList(\StructType\Field $printPickList = null)
    {
        $this->PrintPickList = $printPickList;
        return $this;
    }
    /**
     * Get ConfirmShipment value
     * @return \StructType\Field|null
     */
    public function getConfirmShipment()
    {
        return $this->ConfirmShipment;
    }
    /**
     * Set ConfirmShipment value
     * @param \StructType\Field $confirmShipment
     * @return \StructType\ProcessOrderShipping
     */
    public function setConfirmShipment(\StructType\Field $confirmShipment = null)
    {
        $this->ConfirmShipment = $confirmShipment;
        return $this;
    }
    /**
     * Get PrintLabels value
     * @return \StructType\Field|null
     */
    public function getPrintLabels()
    {
        return $this->PrintLabels;
    }
    /**
     * Set PrintLabels value
     * @param \StructType\Field $printLabels
     * @return \StructType\ProcessOrderShipping
     */
    public function setPrintLabels(\StructType\Field $printLabels = null)
    {
        $this->PrintLabels = $printLabels;
        return $this;
    }
    /**
     * Get PrintShipmentConfirmation value
     * @return \StructType\Field|null
     */
    public function getPrintShipmentConfirmation()
    {
        return $this->PrintShipmentConfirmation;
    }
    /**
     * Set PrintShipmentConfirmation value
     * @param \StructType\Field $printShipmentConfirmation
     * @return \StructType\ProcessOrderShipping
     */
    public function setPrintShipmentConfirmation(\StructType\Field $printShipmentConfirmation = null)
    {
        $this->PrintShipmentConfirmation = $printShipmentConfirmation;
        return $this;
    }
    /**
     * Get UpdateIN value
     * @return \StructType\Field|null
     */
    public function getUpdateIN()
    {
        return $this->UpdateIN;
    }
    /**
     * Set UpdateIN value
     * @param \StructType\Field $updateIN
     * @return \StructType\ProcessOrderShipping
     */
    public function setUpdateIN(\StructType\Field $updateIN = null)
    {
        $this->UpdateIN = $updateIN;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ProcessOrderShippingServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ProcessOrderShippingServiceCommands $serviceCommands
     * @return \StructType\ProcessOrderShipping
     */
    public function setServiceCommands(\StructType\ProcessOrderShippingServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
