<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinancialPaymentInformationOwnership StructType
 * @subpackage Structs
 */
class FinancialPaymentInformationOwnership extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Workgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Workgroup;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Owner;
    /**
     * The OwnerContact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OwnerContact;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FinancialPaymentInformationOwnershipServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for FinancialPaymentInformationOwnership
     * @uses FinancialPaymentInformationOwnership::setDisplayName()
     * @uses FinancialPaymentInformationOwnership::setWorkgroup()
     * @uses FinancialPaymentInformationOwnership::setOwner()
     * @uses FinancialPaymentInformationOwnership::setOwnerContact()
     * @uses FinancialPaymentInformationOwnership::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $workgroup
     * @param \StructType\Field $owner
     * @param \StructType\Field $ownerContact
     * @param \StructType\FinancialPaymentInformationOwnershipServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $workgroup = null, \StructType\Field $owner = null, \StructType\Field $ownerContact = null, \StructType\FinancialPaymentInformationOwnershipServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setWorkgroup($workgroup)
            ->setOwner($owner)
            ->setOwnerContact($ownerContact)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\FinancialPaymentInformationOwnership
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Workgroup value
     * @return \StructType\Field|null
     */
    public function getWorkgroup()
    {
        return $this->Workgroup;
    }
    /**
     * Set Workgroup value
     * @param \StructType\Field $workgroup
     * @return \StructType\FinancialPaymentInformationOwnership
     */
    public function setWorkgroup(\StructType\Field $workgroup = null)
    {
        $this->Workgroup = $workgroup;
        return $this;
    }
    /**
     * Get Owner value
     * @return \StructType\Field|null
     */
    public function getOwner()
    {
        return $this->Owner;
    }
    /**
     * Set Owner value
     * @param \StructType\Field $owner
     * @return \StructType\FinancialPaymentInformationOwnership
     */
    public function setOwner(\StructType\Field $owner = null)
    {
        $this->Owner = $owner;
        return $this;
    }
    /**
     * Get OwnerContact value
     * @return \StructType\Field|null
     */
    public function getOwnerContact()
    {
        return $this->OwnerContact;
    }
    /**
     * Set OwnerContact value
     * @param \StructType\Field $ownerContact
     * @return \StructType\FinancialPaymentInformationOwnership
     */
    public function setOwnerContact(\StructType\Field $ownerContact = null)
    {
        $this->OwnerContact = $ownerContact;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\FinancialPaymentInformationOwnershipServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\FinancialPaymentInformationOwnershipServiceCommands $serviceCommands
     * @return \StructType\FinancialPaymentInformationOwnership
     */
    public function setServiceCommands(\StructType\FinancialPaymentInformationOwnershipServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
