<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinancialPaymentInformation StructType
 * @subpackage Structs
 */
class FinancialPaymentInformation extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The OverridePrepayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OverridePrepayment;
    /**
     * The PrepaymentPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PrepaymentPercent;
    /**
     * The PrepaymentAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PrepaymentAmount;
    /**
     * The PrepaymentRequirementsSatisfied
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PrepaymentRequirementsSatisfied;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PaymentMethod;
    /**
     * The CardAccountNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CardAccountNbr;
    /**
     * The CardAccountNbrIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CardAccountNbrIdentifier;
    /**
     * The CashAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CashAccount;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PaymentRef;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FinancialPaymentInformationServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for FinancialPaymentInformation
     * @uses FinancialPaymentInformation::setDisplayName()
     * @uses FinancialPaymentInformation::setOverridePrepayment()
     * @uses FinancialPaymentInformation::setPrepaymentPercent()
     * @uses FinancialPaymentInformation::setPrepaymentAmount()
     * @uses FinancialPaymentInformation::setPrepaymentRequirementsSatisfied()
     * @uses FinancialPaymentInformation::setPaymentMethod()
     * @uses FinancialPaymentInformation::setCardAccountNbr()
     * @uses FinancialPaymentInformation::setCardAccountNbrIdentifier()
     * @uses FinancialPaymentInformation::setCashAccount()
     * @uses FinancialPaymentInformation::setPaymentRef()
     * @uses FinancialPaymentInformation::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $overridePrepayment
     * @param \StructType\Field $prepaymentPercent
     * @param \StructType\Field $prepaymentAmount
     * @param \StructType\Field $prepaymentRequirementsSatisfied
     * @param \StructType\Field $paymentMethod
     * @param \StructType\Field $cardAccountNbr
     * @param \StructType\Field $cardAccountNbrIdentifier
     * @param \StructType\Field $cashAccount
     * @param \StructType\Field $paymentRef
     * @param \StructType\FinancialPaymentInformationServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $overridePrepayment = null, \StructType\Field $prepaymentPercent = null, \StructType\Field $prepaymentAmount = null, \StructType\Field $prepaymentRequirementsSatisfied = null, \StructType\Field $paymentMethod = null, \StructType\Field $cardAccountNbr = null, \StructType\Field $cardAccountNbrIdentifier = null, \StructType\Field $cashAccount = null, \StructType\Field $paymentRef = null, \StructType\FinancialPaymentInformationServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setOverridePrepayment($overridePrepayment)
            ->setPrepaymentPercent($prepaymentPercent)
            ->setPrepaymentAmount($prepaymentAmount)
            ->setPrepaymentRequirementsSatisfied($prepaymentRequirementsSatisfied)
            ->setPaymentMethod($paymentMethod)
            ->setCardAccountNbr($cardAccountNbr)
            ->setCardAccountNbrIdentifier($cardAccountNbrIdentifier)
            ->setCashAccount($cashAccount)
            ->setPaymentRef($paymentRef)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\FinancialPaymentInformation
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get OverridePrepayment value
     * @return \StructType\Field|null
     */
    public function getOverridePrepayment()
    {
        return $this->OverridePrepayment;
    }
    /**
     * Set OverridePrepayment value
     * @param \StructType\Field $overridePrepayment
     * @return \StructType\FinancialPaymentInformation
     */
    public function setOverridePrepayment(\StructType\Field $overridePrepayment = null)
    {
        $this->OverridePrepayment = $overridePrepayment;
        return $this;
    }
    /**
     * Get PrepaymentPercent value
     * @return \StructType\Field|null
     */
    public function getPrepaymentPercent()
    {
        return $this->PrepaymentPercent;
    }
    /**
     * Set PrepaymentPercent value
     * @param \StructType\Field $prepaymentPercent
     * @return \StructType\FinancialPaymentInformation
     */
    public function setPrepaymentPercent(\StructType\Field $prepaymentPercent = null)
    {
        $this->PrepaymentPercent = $prepaymentPercent;
        return $this;
    }
    /**
     * Get PrepaymentAmount value
     * @return \StructType\Field|null
     */
    public function getPrepaymentAmount()
    {
        return $this->PrepaymentAmount;
    }
    /**
     * Set PrepaymentAmount value
     * @param \StructType\Field $prepaymentAmount
     * @return \StructType\FinancialPaymentInformation
     */
    public function setPrepaymentAmount(\StructType\Field $prepaymentAmount = null)
    {
        $this->PrepaymentAmount = $prepaymentAmount;
        return $this;
    }
    /**
     * Get PrepaymentRequirementsSatisfied value
     * @return \StructType\Field|null
     */
    public function getPrepaymentRequirementsSatisfied()
    {
        return $this->PrepaymentRequirementsSatisfied;
    }
    /**
     * Set PrepaymentRequirementsSatisfied value
     * @param \StructType\Field $prepaymentRequirementsSatisfied
     * @return \StructType\FinancialPaymentInformation
     */
    public function setPrepaymentRequirementsSatisfied(\StructType\Field $prepaymentRequirementsSatisfied = null)
    {
        $this->PrepaymentRequirementsSatisfied = $prepaymentRequirementsSatisfied;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return \StructType\Field|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param \StructType\Field $paymentMethod
     * @return \StructType\FinancialPaymentInformation
     */
    public function setPaymentMethod(\StructType\Field $paymentMethod = null)
    {
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get CardAccountNbr value
     * @return \StructType\Field|null
     */
    public function getCardAccountNbr()
    {
        return $this->CardAccountNbr;
    }
    /**
     * Set CardAccountNbr value
     * @param \StructType\Field $cardAccountNbr
     * @return \StructType\FinancialPaymentInformation
     */
    public function setCardAccountNbr(\StructType\Field $cardAccountNbr = null)
    {
        $this->CardAccountNbr = $cardAccountNbr;
        return $this;
    }
    /**
     * Get CardAccountNbrIdentifier value
     * @return \StructType\Field|null
     */
    public function getCardAccountNbrIdentifier()
    {
        return $this->CardAccountNbrIdentifier;
    }
    /**
     * Set CardAccountNbrIdentifier value
     * @param \StructType\Field $cardAccountNbrIdentifier
     * @return \StructType\FinancialPaymentInformation
     */
    public function setCardAccountNbrIdentifier(\StructType\Field $cardAccountNbrIdentifier = null)
    {
        $this->CardAccountNbrIdentifier = $cardAccountNbrIdentifier;
        return $this;
    }
    /**
     * Get CashAccount value
     * @return \StructType\Field|null
     */
    public function getCashAccount()
    {
        return $this->CashAccount;
    }
    /**
     * Set CashAccount value
     * @param \StructType\Field $cashAccount
     * @return \StructType\FinancialPaymentInformation
     */
    public function setCashAccount(\StructType\Field $cashAccount = null)
    {
        $this->CashAccount = $cashAccount;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return \StructType\Field|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param \StructType\Field $paymentRef
     * @return \StructType\FinancialPaymentInformation
     */
    public function setPaymentRef(\StructType\Field $paymentRef = null)
    {
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\FinancialPaymentInformationServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\FinancialPaymentInformationServiceCommands $serviceCommands
     * @return \StructType\FinancialPaymentInformation
     */
    public function setServiceCommands(\StructType\FinancialPaymentInformationServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
