<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnterReason StructType
 * @subpackage Structs
 */
class EnterReason extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Reason;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EnterReasonServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for EnterReason
     * @uses EnterReason::setDisplayName()
     * @uses EnterReason::setReason()
     * @uses EnterReason::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $reason
     * @param \StructType\EnterReasonServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $reason = null, \StructType\EnterReasonServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setReason($reason)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\EnterReason
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Reason value
     * @return \StructType\Field|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param \StructType\Field $reason
     * @return \StructType\EnterReason
     */
    public function setReason(\StructType\Field $reason = null)
    {
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\EnterReasonServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\EnterReasonServiceCommands $serviceCommands
     * @return \StructType\EnterReason
     */
    public function setServiceCommands(\StructType\EnterReasonServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
