<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuickEstimate StructType
 * @subpackage Structs
 */
class QuickEstimate extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The EstimateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EstimateID;
    /**
     * The RevisionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RevisionID;
    /**
     * The InventoryCD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryCD;
    /**
     * The IsNonInventory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $IsNonInventory;
    /**
     * The SubItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SubItemID;
    /**
     * The SiteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SiteID;
    /**
     * The ItemDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ItemDesc;
    /**
     * The EstimateClassID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EstimateClassID;
    /**
     * The FixedLaborCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FixedLaborCost;
    /**
     * The FixedLaborOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FixedLaborOverride;
    /**
     * The VariableLaborCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VariableLaborCost;
    /**
     * The VariableLaborOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VariableLaborOverride;
    /**
     * The MachineCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MachineCost;
    /**
     * The MachineOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MachineOverride;
    /**
     * The MaterialCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MaterialCost;
    /**
     * The MaterialOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MaterialOverride;
    /**
     * The ToolCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ToolCost;
    /**
     * The ToolOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ToolOverride;
    /**
     * The FixedOverheadCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FixedOverheadCost;
    /**
     * The FixedOverheadOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FixedOverheadOverride;
    /**
     * The VariableOverheadCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VariableOverheadCost;
    /**
     * The VariableOverheadOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $VariableOverheadOverride;
    /**
     * The SubcontractCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SubcontractCost;
    /**
     * The SubcontractOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SubcontractOverride;
    /**
     * The ExtCostDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExtCostDisplay;
    /**
     * The ReferenceMaterialCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReferenceMaterialCost;
    /**
     * The OrderQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderQty;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The CuryUnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CuryUnitCost;
    /**
     * The MarkupPct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MarkupPct;
    /**
     * The CuryUnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CuryUnitPrice;
    /**
     * The PriceOverride
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PriceOverride;
    /**
     * The CuryExtPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CuryExtPrice;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\QuickEstimateServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for QuickEstimate
     * @uses QuickEstimate::setDisplayName()
     * @uses QuickEstimate::setEstimateID()
     * @uses QuickEstimate::setRevisionID()
     * @uses QuickEstimate::setInventoryCD()
     * @uses QuickEstimate::setIsNonInventory()
     * @uses QuickEstimate::setSubItemID()
     * @uses QuickEstimate::setSiteID()
     * @uses QuickEstimate::setItemDesc()
     * @uses QuickEstimate::setEstimateClassID()
     * @uses QuickEstimate::setFixedLaborCost()
     * @uses QuickEstimate::setFixedLaborOverride()
     * @uses QuickEstimate::setVariableLaborCost()
     * @uses QuickEstimate::setVariableLaborOverride()
     * @uses QuickEstimate::setMachineCost()
     * @uses QuickEstimate::setMachineOverride()
     * @uses QuickEstimate::setMaterialCost()
     * @uses QuickEstimate::setMaterialOverride()
     * @uses QuickEstimate::setToolCost()
     * @uses QuickEstimate::setToolOverride()
     * @uses QuickEstimate::setFixedOverheadCost()
     * @uses QuickEstimate::setFixedOverheadOverride()
     * @uses QuickEstimate::setVariableOverheadCost()
     * @uses QuickEstimate::setVariableOverheadOverride()
     * @uses QuickEstimate::setSubcontractCost()
     * @uses QuickEstimate::setSubcontractOverride()
     * @uses QuickEstimate::setExtCostDisplay()
     * @uses QuickEstimate::setReferenceMaterialCost()
     * @uses QuickEstimate::setOrderQty()
     * @uses QuickEstimate::setUOM()
     * @uses QuickEstimate::setCuryUnitCost()
     * @uses QuickEstimate::setMarkupPct()
     * @uses QuickEstimate::setCuryUnitPrice()
     * @uses QuickEstimate::setPriceOverride()
     * @uses QuickEstimate::setCuryExtPrice()
     * @uses QuickEstimate::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $estimateID
     * @param \StructType\Field $revisionID
     * @param \StructType\Field $inventoryCD
     * @param \StructType\Field $isNonInventory
     * @param \StructType\Field $subItemID
     * @param \StructType\Field $siteID
     * @param \StructType\Field $itemDesc
     * @param \StructType\Field $estimateClassID
     * @param \StructType\Field $fixedLaborCost
     * @param \StructType\Field $fixedLaborOverride
     * @param \StructType\Field $variableLaborCost
     * @param \StructType\Field $variableLaborOverride
     * @param \StructType\Field $machineCost
     * @param \StructType\Field $machineOverride
     * @param \StructType\Field $materialCost
     * @param \StructType\Field $materialOverride
     * @param \StructType\Field $toolCost
     * @param \StructType\Field $toolOverride
     * @param \StructType\Field $fixedOverheadCost
     * @param \StructType\Field $fixedOverheadOverride
     * @param \StructType\Field $variableOverheadCost
     * @param \StructType\Field $variableOverheadOverride
     * @param \StructType\Field $subcontractCost
     * @param \StructType\Field $subcontractOverride
     * @param \StructType\Field $extCostDisplay
     * @param \StructType\Field $referenceMaterialCost
     * @param \StructType\Field $orderQty
     * @param \StructType\Field $uOM
     * @param \StructType\Field $curyUnitCost
     * @param \StructType\Field $markupPct
     * @param \StructType\Field $curyUnitPrice
     * @param \StructType\Field $priceOverride
     * @param \StructType\Field $curyExtPrice
     * @param \StructType\QuickEstimateServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $estimateID = null, \StructType\Field $revisionID = null, \StructType\Field $inventoryCD = null, \StructType\Field $isNonInventory = null, \StructType\Field $subItemID = null, \StructType\Field $siteID = null, \StructType\Field $itemDesc = null, \StructType\Field $estimateClassID = null, \StructType\Field $fixedLaborCost = null, \StructType\Field $fixedLaborOverride = null, \StructType\Field $variableLaborCost = null, \StructType\Field $variableLaborOverride = null, \StructType\Field $machineCost = null, \StructType\Field $machineOverride = null, \StructType\Field $materialCost = null, \StructType\Field $materialOverride = null, \StructType\Field $toolCost = null, \StructType\Field $toolOverride = null, \StructType\Field $fixedOverheadCost = null, \StructType\Field $fixedOverheadOverride = null, \StructType\Field $variableOverheadCost = null, \StructType\Field $variableOverheadOverride = null, \StructType\Field $subcontractCost = null, \StructType\Field $subcontractOverride = null, \StructType\Field $extCostDisplay = null, \StructType\Field $referenceMaterialCost = null, \StructType\Field $orderQty = null, \StructType\Field $uOM = null, \StructType\Field $curyUnitCost = null, \StructType\Field $markupPct = null, \StructType\Field $curyUnitPrice = null, \StructType\Field $priceOverride = null, \StructType\Field $curyExtPrice = null, \StructType\QuickEstimateServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setEstimateID($estimateID)
            ->setRevisionID($revisionID)
            ->setInventoryCD($inventoryCD)
            ->setIsNonInventory($isNonInventory)
            ->setSubItemID($subItemID)
            ->setSiteID($siteID)
            ->setItemDesc($itemDesc)
            ->setEstimateClassID($estimateClassID)
            ->setFixedLaborCost($fixedLaborCost)
            ->setFixedLaborOverride($fixedLaborOverride)
            ->setVariableLaborCost($variableLaborCost)
            ->setVariableLaborOverride($variableLaborOverride)
            ->setMachineCost($machineCost)
            ->setMachineOverride($machineOverride)
            ->setMaterialCost($materialCost)
            ->setMaterialOverride($materialOverride)
            ->setToolCost($toolCost)
            ->setToolOverride($toolOverride)
            ->setFixedOverheadCost($fixedOverheadCost)
            ->setFixedOverheadOverride($fixedOverheadOverride)
            ->setVariableOverheadCost($variableOverheadCost)
            ->setVariableOverheadOverride($variableOverheadOverride)
            ->setSubcontractCost($subcontractCost)
            ->setSubcontractOverride($subcontractOverride)
            ->setExtCostDisplay($extCostDisplay)
            ->setReferenceMaterialCost($referenceMaterialCost)
            ->setOrderQty($orderQty)
            ->setUOM($uOM)
            ->setCuryUnitCost($curyUnitCost)
            ->setMarkupPct($markupPct)
            ->setCuryUnitPrice($curyUnitPrice)
            ->setPriceOverride($priceOverride)
            ->setCuryExtPrice($curyExtPrice)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\QuickEstimate
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get EstimateID value
     * @return \StructType\Field|null
     */
    public function getEstimateID()
    {
        return $this->EstimateID;
    }
    /**
     * Set EstimateID value
     * @param \StructType\Field $estimateID
     * @return \StructType\QuickEstimate
     */
    public function setEstimateID(\StructType\Field $estimateID = null)
    {
        $this->EstimateID = $estimateID;
        return $this;
    }
    /**
     * Get RevisionID value
     * @return \StructType\Field|null
     */
    public function getRevisionID()
    {
        return $this->RevisionID;
    }
    /**
     * Set RevisionID value
     * @param \StructType\Field $revisionID
     * @return \StructType\QuickEstimate
     */
    public function setRevisionID(\StructType\Field $revisionID = null)
    {
        $this->RevisionID = $revisionID;
        return $this;
    }
    /**
     * Get InventoryCD value
     * @return \StructType\Field|null
     */
    public function getInventoryCD()
    {
        return $this->InventoryCD;
    }
    /**
     * Set InventoryCD value
     * @param \StructType\Field $inventoryCD
     * @return \StructType\QuickEstimate
     */
    public function setInventoryCD(\StructType\Field $inventoryCD = null)
    {
        $this->InventoryCD = $inventoryCD;
        return $this;
    }
    /**
     * Get IsNonInventory value
     * @return \StructType\Field|null
     */
    public function getIsNonInventory()
    {
        return $this->IsNonInventory;
    }
    /**
     * Set IsNonInventory value
     * @param \StructType\Field $isNonInventory
     * @return \StructType\QuickEstimate
     */
    public function setIsNonInventory(\StructType\Field $isNonInventory = null)
    {
        $this->IsNonInventory = $isNonInventory;
        return $this;
    }
    /**
     * Get SubItemID value
     * @return \StructType\Field|null
     */
    public function getSubItemID()
    {
        return $this->SubItemID;
    }
    /**
     * Set SubItemID value
     * @param \StructType\Field $subItemID
     * @return \StructType\QuickEstimate
     */
    public function setSubItemID(\StructType\Field $subItemID = null)
    {
        $this->SubItemID = $subItemID;
        return $this;
    }
    /**
     * Get SiteID value
     * @return \StructType\Field|null
     */
    public function getSiteID()
    {
        return $this->SiteID;
    }
    /**
     * Set SiteID value
     * @param \StructType\Field $siteID
     * @return \StructType\QuickEstimate
     */
    public function setSiteID(\StructType\Field $siteID = null)
    {
        $this->SiteID = $siteID;
        return $this;
    }
    /**
     * Get ItemDesc value
     * @return \StructType\Field|null
     */
    public function getItemDesc()
    {
        return $this->ItemDesc;
    }
    /**
     * Set ItemDesc value
     * @param \StructType\Field $itemDesc
     * @return \StructType\QuickEstimate
     */
    public function setItemDesc(\StructType\Field $itemDesc = null)
    {
        $this->ItemDesc = $itemDesc;
        return $this;
    }
    /**
     * Get EstimateClassID value
     * @return \StructType\Field|null
     */
    public function getEstimateClassID()
    {
        return $this->EstimateClassID;
    }
    /**
     * Set EstimateClassID value
     * @param \StructType\Field $estimateClassID
     * @return \StructType\QuickEstimate
     */
    public function setEstimateClassID(\StructType\Field $estimateClassID = null)
    {
        $this->EstimateClassID = $estimateClassID;
        return $this;
    }
    /**
     * Get FixedLaborCost value
     * @return \StructType\Field|null
     */
    public function getFixedLaborCost()
    {
        return $this->FixedLaborCost;
    }
    /**
     * Set FixedLaborCost value
     * @param \StructType\Field $fixedLaborCost
     * @return \StructType\QuickEstimate
     */
    public function setFixedLaborCost(\StructType\Field $fixedLaborCost = null)
    {
        $this->FixedLaborCost = $fixedLaborCost;
        return $this;
    }
    /**
     * Get FixedLaborOverride value
     * @return \StructType\Field|null
     */
    public function getFixedLaborOverride()
    {
        return $this->FixedLaborOverride;
    }
    /**
     * Set FixedLaborOverride value
     * @param \StructType\Field $fixedLaborOverride
     * @return \StructType\QuickEstimate
     */
    public function setFixedLaborOverride(\StructType\Field $fixedLaborOverride = null)
    {
        $this->FixedLaborOverride = $fixedLaborOverride;
        return $this;
    }
    /**
     * Get VariableLaborCost value
     * @return \StructType\Field|null
     */
    public function getVariableLaborCost()
    {
        return $this->VariableLaborCost;
    }
    /**
     * Set VariableLaborCost value
     * @param \StructType\Field $variableLaborCost
     * @return \StructType\QuickEstimate
     */
    public function setVariableLaborCost(\StructType\Field $variableLaborCost = null)
    {
        $this->VariableLaborCost = $variableLaborCost;
        return $this;
    }
    /**
     * Get VariableLaborOverride value
     * @return \StructType\Field|null
     */
    public function getVariableLaborOverride()
    {
        return $this->VariableLaborOverride;
    }
    /**
     * Set VariableLaborOverride value
     * @param \StructType\Field $variableLaborOverride
     * @return \StructType\QuickEstimate
     */
    public function setVariableLaborOverride(\StructType\Field $variableLaborOverride = null)
    {
        $this->VariableLaborOverride = $variableLaborOverride;
        return $this;
    }
    /**
     * Get MachineCost value
     * @return \StructType\Field|null
     */
    public function getMachineCost()
    {
        return $this->MachineCost;
    }
    /**
     * Set MachineCost value
     * @param \StructType\Field $machineCost
     * @return \StructType\QuickEstimate
     */
    public function setMachineCost(\StructType\Field $machineCost = null)
    {
        $this->MachineCost = $machineCost;
        return $this;
    }
    /**
     * Get MachineOverride value
     * @return \StructType\Field|null
     */
    public function getMachineOverride()
    {
        return $this->MachineOverride;
    }
    /**
     * Set MachineOverride value
     * @param \StructType\Field $machineOverride
     * @return \StructType\QuickEstimate
     */
    public function setMachineOverride(\StructType\Field $machineOverride = null)
    {
        $this->MachineOverride = $machineOverride;
        return $this;
    }
    /**
     * Get MaterialCost value
     * @return \StructType\Field|null
     */
    public function getMaterialCost()
    {
        return $this->MaterialCost;
    }
    /**
     * Set MaterialCost value
     * @param \StructType\Field $materialCost
     * @return \StructType\QuickEstimate
     */
    public function setMaterialCost(\StructType\Field $materialCost = null)
    {
        $this->MaterialCost = $materialCost;
        return $this;
    }
    /**
     * Get MaterialOverride value
     * @return \StructType\Field|null
     */
    public function getMaterialOverride()
    {
        return $this->MaterialOverride;
    }
    /**
     * Set MaterialOverride value
     * @param \StructType\Field $materialOverride
     * @return \StructType\QuickEstimate
     */
    public function setMaterialOverride(\StructType\Field $materialOverride = null)
    {
        $this->MaterialOverride = $materialOverride;
        return $this;
    }
    /**
     * Get ToolCost value
     * @return \StructType\Field|null
     */
    public function getToolCost()
    {
        return $this->ToolCost;
    }
    /**
     * Set ToolCost value
     * @param \StructType\Field $toolCost
     * @return \StructType\QuickEstimate
     */
    public function setToolCost(\StructType\Field $toolCost = null)
    {
        $this->ToolCost = $toolCost;
        return $this;
    }
    /**
     * Get ToolOverride value
     * @return \StructType\Field|null
     */
    public function getToolOverride()
    {
        return $this->ToolOverride;
    }
    /**
     * Set ToolOverride value
     * @param \StructType\Field $toolOverride
     * @return \StructType\QuickEstimate
     */
    public function setToolOverride(\StructType\Field $toolOverride = null)
    {
        $this->ToolOverride = $toolOverride;
        return $this;
    }
    /**
     * Get FixedOverheadCost value
     * @return \StructType\Field|null
     */
    public function getFixedOverheadCost()
    {
        return $this->FixedOverheadCost;
    }
    /**
     * Set FixedOverheadCost value
     * @param \StructType\Field $fixedOverheadCost
     * @return \StructType\QuickEstimate
     */
    public function setFixedOverheadCost(\StructType\Field $fixedOverheadCost = null)
    {
        $this->FixedOverheadCost = $fixedOverheadCost;
        return $this;
    }
    /**
     * Get FixedOverheadOverride value
     * @return \StructType\Field|null
     */
    public function getFixedOverheadOverride()
    {
        return $this->FixedOverheadOverride;
    }
    /**
     * Set FixedOverheadOverride value
     * @param \StructType\Field $fixedOverheadOverride
     * @return \StructType\QuickEstimate
     */
    public function setFixedOverheadOverride(\StructType\Field $fixedOverheadOverride = null)
    {
        $this->FixedOverheadOverride = $fixedOverheadOverride;
        return $this;
    }
    /**
     * Get VariableOverheadCost value
     * @return \StructType\Field|null
     */
    public function getVariableOverheadCost()
    {
        return $this->VariableOverheadCost;
    }
    /**
     * Set VariableOverheadCost value
     * @param \StructType\Field $variableOverheadCost
     * @return \StructType\QuickEstimate
     */
    public function setVariableOverheadCost(\StructType\Field $variableOverheadCost = null)
    {
        $this->VariableOverheadCost = $variableOverheadCost;
        return $this;
    }
    /**
     * Get VariableOverheadOverride value
     * @return \StructType\Field|null
     */
    public function getVariableOverheadOverride()
    {
        return $this->VariableOverheadOverride;
    }
    /**
     * Set VariableOverheadOverride value
     * @param \StructType\Field $variableOverheadOverride
     * @return \StructType\QuickEstimate
     */
    public function setVariableOverheadOverride(\StructType\Field $variableOverheadOverride = null)
    {
        $this->VariableOverheadOverride = $variableOverheadOverride;
        return $this;
    }
    /**
     * Get SubcontractCost value
     * @return \StructType\Field|null
     */
    public function getSubcontractCost()
    {
        return $this->SubcontractCost;
    }
    /**
     * Set SubcontractCost value
     * @param \StructType\Field $subcontractCost
     * @return \StructType\QuickEstimate
     */
    public function setSubcontractCost(\StructType\Field $subcontractCost = null)
    {
        $this->SubcontractCost = $subcontractCost;
        return $this;
    }
    /**
     * Get SubcontractOverride value
     * @return \StructType\Field|null
     */
    public function getSubcontractOverride()
    {
        return $this->SubcontractOverride;
    }
    /**
     * Set SubcontractOverride value
     * @param \StructType\Field $subcontractOverride
     * @return \StructType\QuickEstimate
     */
    public function setSubcontractOverride(\StructType\Field $subcontractOverride = null)
    {
        $this->SubcontractOverride = $subcontractOverride;
        return $this;
    }
    /**
     * Get ExtCostDisplay value
     * @return \StructType\Field|null
     */
    public function getExtCostDisplay()
    {
        return $this->ExtCostDisplay;
    }
    /**
     * Set ExtCostDisplay value
     * @param \StructType\Field $extCostDisplay
     * @return \StructType\QuickEstimate
     */
    public function setExtCostDisplay(\StructType\Field $extCostDisplay = null)
    {
        $this->ExtCostDisplay = $extCostDisplay;
        return $this;
    }
    /**
     * Get ReferenceMaterialCost value
     * @return \StructType\Field|null
     */
    public function getReferenceMaterialCost()
    {
        return $this->ReferenceMaterialCost;
    }
    /**
     * Set ReferenceMaterialCost value
     * @param \StructType\Field $referenceMaterialCost
     * @return \StructType\QuickEstimate
     */
    public function setReferenceMaterialCost(\StructType\Field $referenceMaterialCost = null)
    {
        $this->ReferenceMaterialCost = $referenceMaterialCost;
        return $this;
    }
    /**
     * Get OrderQty value
     * @return \StructType\Field|null
     */
    public function getOrderQty()
    {
        return $this->OrderQty;
    }
    /**
     * Set OrderQty value
     * @param \StructType\Field $orderQty
     * @return \StructType\QuickEstimate
     */
    public function setOrderQty(\StructType\Field $orderQty = null)
    {
        $this->OrderQty = $orderQty;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\QuickEstimate
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get CuryUnitCost value
     * @return \StructType\Field|null
     */
    public function getCuryUnitCost()
    {
        return $this->CuryUnitCost;
    }
    /**
     * Set CuryUnitCost value
     * @param \StructType\Field $curyUnitCost
     * @return \StructType\QuickEstimate
     */
    public function setCuryUnitCost(\StructType\Field $curyUnitCost = null)
    {
        $this->CuryUnitCost = $curyUnitCost;
        return $this;
    }
    /**
     * Get MarkupPct value
     * @return \StructType\Field|null
     */
    public function getMarkupPct()
    {
        return $this->MarkupPct;
    }
    /**
     * Set MarkupPct value
     * @param \StructType\Field $markupPct
     * @return \StructType\QuickEstimate
     */
    public function setMarkupPct(\StructType\Field $markupPct = null)
    {
        $this->MarkupPct = $markupPct;
        return $this;
    }
    /**
     * Get CuryUnitPrice value
     * @return \StructType\Field|null
     */
    public function getCuryUnitPrice()
    {
        return $this->CuryUnitPrice;
    }
    /**
     * Set CuryUnitPrice value
     * @param \StructType\Field $curyUnitPrice
     * @return \StructType\QuickEstimate
     */
    public function setCuryUnitPrice(\StructType\Field $curyUnitPrice = null)
    {
        $this->CuryUnitPrice = $curyUnitPrice;
        return $this;
    }
    /**
     * Get PriceOverride value
     * @return \StructType\Field|null
     */
    public function getPriceOverride()
    {
        return $this->PriceOverride;
    }
    /**
     * Set PriceOverride value
     * @param \StructType\Field $priceOverride
     * @return \StructType\QuickEstimate
     */
    public function setPriceOverride(\StructType\Field $priceOverride = null)
    {
        $this->PriceOverride = $priceOverride;
        return $this;
    }
    /**
     * Get CuryExtPrice value
     * @return \StructType\Field|null
     */
    public function getCuryExtPrice()
    {
        return $this->CuryExtPrice;
    }
    /**
     * Set CuryExtPrice value
     * @param \StructType\Field $curyExtPrice
     * @return \StructType\QuickEstimate
     */
    public function setCuryExtPrice(\StructType\Field $curyExtPrice = null)
    {
        $this->CuryExtPrice = $curyExtPrice;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\QuickEstimateServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\QuickEstimateServiceCommands $serviceCommands
     * @return \StructType\QuickEstimate
     */
    public function setServiceCommands(\StructType\QuickEstimateServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
