<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportResult StructType
 * @subpackage Structs
 */
class ImportResult extends AbstractStructBase
{
    /**
     * The Processed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Processed;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Error;
    /**
     * The Keys
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrimaryKey
     */
    public $Keys;
    /**
     * Constructor method for ImportResult
     * @uses ImportResult::setProcessed()
     * @uses ImportResult::setError()
     * @uses ImportResult::setKeys()
     * @param bool $processed
     * @param string $error
     * @param \StructType\PrimaryKey $keys
     */
    public function __construct($processed = null, $error = null, \StructType\PrimaryKey $keys = null)
    {
        $this
            ->setProcessed($processed)
            ->setError($error)
            ->setKeys($keys);
    }
    /**
     * Get Processed value
     * @return bool
     */
    public function getProcessed()
    {
        return $this->Processed;
    }
    /**
     * Set Processed value
     * @param bool $processed
     * @return \StructType\ImportResult
     */
    public function setProcessed($processed = null)
    {
        // validation for constraint: boolean
        if (!is_null($processed) && !is_bool($processed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($processed, true), gettype($processed)), __LINE__);
        }
        $this->Processed = $processed;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \StructType\ImportResult
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get Keys value
     * @return \StructType\PrimaryKey|null
     */
    public function getKeys()
    {
        return $this->Keys;
    }
    /**
     * Set Keys value
     * @param \StructType\PrimaryKey $keys
     * @return \StructType\ImportResult
     */
    public function setKeys(\StructType\PrimaryKey $keys = null)
    {
        $this->Keys = $keys;
        return $this;
    }
}
