<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Risks StructType
 * @subpackage Structs
 */
class Risks extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineNbr;
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Score;
    /**
     * The Recommendation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Recommendation;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Message;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RisksServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Risks
     * @uses Risks::setDisplayName()
     * @uses Risks::setLineNbr()
     * @uses Risks::setScore()
     * @uses Risks::setRecommendation()
     * @uses Risks::setMessage()
     * @uses Risks::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $lineNbr
     * @param \StructType\Field $score
     * @param \StructType\Field $recommendation
     * @param \StructType\Field $message
     * @param \StructType\RisksServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $lineNbr = null, \StructType\Field $score = null, \StructType\Field $recommendation = null, \StructType\Field $message = null, \StructType\RisksServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setLineNbr($lineNbr)
            ->setScore($score)
            ->setRecommendation($recommendation)
            ->setMessage($message)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Risks
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get LineNbr value
     * @return \StructType\Field|null
     */
    public function getLineNbr()
    {
        return $this->LineNbr;
    }
    /**
     * Set LineNbr value
     * @param \StructType\Field $lineNbr
     * @return \StructType\Risks
     */
    public function setLineNbr(\StructType\Field $lineNbr = null)
    {
        $this->LineNbr = $lineNbr;
        return $this;
    }
    /**
     * Get Score value
     * @return \StructType\Field|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param \StructType\Field $score
     * @return \StructType\Risks
     */
    public function setScore(\StructType\Field $score = null)
    {
        $this->Score = $score;
        return $this;
    }
    /**
     * Get Recommendation value
     * @return \StructType\Field|null
     */
    public function getRecommendation()
    {
        return $this->Recommendation;
    }
    /**
     * Set Recommendation value
     * @param \StructType\Field $recommendation
     * @return \StructType\Risks
     */
    public function setRecommendation(\StructType\Field $recommendation = null)
    {
        $this->Recommendation = $recommendation;
        return $this;
    }
    /**
     * Get Message value
     * @return \StructType\Field|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \StructType\Field $message
     * @return \StructType\Risks
     */
    public function setMessage(\StructType\Field $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\RisksServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\RisksServiceCommands $serviceCommands
     * @return \StructType\Risks
     */
    public function setServiceCommands(\StructType\RisksServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
