<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductionDetails StructType
 * @subpackage Structs
 */
class ProductionDetails extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Selected
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Selected;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The ProdOrdID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProdOrdID;
    /**
     * The StatusID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $StatusID;
    /**
     * The QtytoProd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtytoProd;
    /**
     * The QtyComplete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyComplete;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductionDetailsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ProductionDetails
     * @uses ProductionDetails::setDisplayName()
     * @uses ProductionDetails::setSelected()
     * @uses ProductionDetails::setOrderType()
     * @uses ProductionDetails::setProdOrdID()
     * @uses ProductionDetails::setStatusID()
     * @uses ProductionDetails::setQtytoProd()
     * @uses ProductionDetails::setQtyComplete()
     * @uses ProductionDetails::setUOM()
     * @uses ProductionDetails::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $selected
     * @param \StructType\Field $orderType
     * @param \StructType\Field $prodOrdID
     * @param \StructType\Field $statusID
     * @param \StructType\Field $qtytoProd
     * @param \StructType\Field $qtyComplete
     * @param \StructType\Field $uOM
     * @param \StructType\ProductionDetailsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $selected = null, \StructType\Field $orderType = null, \StructType\Field $prodOrdID = null, \StructType\Field $statusID = null, \StructType\Field $qtytoProd = null, \StructType\Field $qtyComplete = null, \StructType\Field $uOM = null, \StructType\ProductionDetailsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setSelected($selected)
            ->setOrderType($orderType)
            ->setProdOrdID($prodOrdID)
            ->setStatusID($statusID)
            ->setQtytoProd($qtytoProd)
            ->setQtyComplete($qtyComplete)
            ->setUOM($uOM)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ProductionDetails
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Selected value
     * @return \StructType\Field|null
     */
    public function getSelected()
    {
        return $this->Selected;
    }
    /**
     * Set Selected value
     * @param \StructType\Field $selected
     * @return \StructType\ProductionDetails
     */
    public function setSelected(\StructType\Field $selected = null)
    {
        $this->Selected = $selected;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\ProductionDetails
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get ProdOrdID value
     * @return \StructType\Field|null
     */
    public function getProdOrdID()
    {
        return $this->ProdOrdID;
    }
    /**
     * Set ProdOrdID value
     * @param \StructType\Field $prodOrdID
     * @return \StructType\ProductionDetails
     */
    public function setProdOrdID(\StructType\Field $prodOrdID = null)
    {
        $this->ProdOrdID = $prodOrdID;
        return $this;
    }
    /**
     * Get StatusID value
     * @return \StructType\Field|null
     */
    public function getStatusID()
    {
        return $this->StatusID;
    }
    /**
     * Set StatusID value
     * @param \StructType\Field $statusID
     * @return \StructType\ProductionDetails
     */
    public function setStatusID(\StructType\Field $statusID = null)
    {
        $this->StatusID = $statusID;
        return $this;
    }
    /**
     * Get QtytoProd value
     * @return \StructType\Field|null
     */
    public function getQtytoProd()
    {
        return $this->QtytoProd;
    }
    /**
     * Set QtytoProd value
     * @param \StructType\Field $qtytoProd
     * @return \StructType\ProductionDetails
     */
    public function setQtytoProd(\StructType\Field $qtytoProd = null)
    {
        $this->QtytoProd = $qtytoProd;
        return $this;
    }
    /**
     * Get QtyComplete value
     * @return \StructType\Field|null
     */
    public function getQtyComplete()
    {
        return $this->QtyComplete;
    }
    /**
     * Set QtyComplete value
     * @param \StructType\Field $qtyComplete
     * @return \StructType\ProductionDetails
     */
    public function setQtyComplete(\StructType\Field $qtyComplete = null)
    {
        $this->QtyComplete = $qtyComplete;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\ProductionDetails
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ProductionDetailsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ProductionDetailsServiceCommands $serviceCommands
     * @return \StructType\ProductionDetails
     */
    public function setServiceCommands(\StructType\ProductionDetailsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
