<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportCCPayment StructType
 * @subpackage Structs
 */
class ImportCCPayment extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The TranNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TranNumber;
    /**
     * The ProcessingCenterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProcessingCenterID;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ImportCCPaymentServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for ImportCCPayment
     * @uses ImportCCPayment::setDisplayName()
     * @uses ImportCCPayment::setTranNumber()
     * @uses ImportCCPayment::setProcessingCenterID()
     * @uses ImportCCPayment::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $tranNumber
     * @param \StructType\Field $processingCenterID
     * @param \StructType\ImportCCPaymentServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $tranNumber = null, \StructType\Field $processingCenterID = null, \StructType\ImportCCPaymentServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setTranNumber($tranNumber)
            ->setProcessingCenterID($processingCenterID)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\ImportCCPayment
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get TranNumber value
     * @return \StructType\Field|null
     */
    public function getTranNumber()
    {
        return $this->TranNumber;
    }
    /**
     * Set TranNumber value
     * @param \StructType\Field $tranNumber
     * @return \StructType\ImportCCPayment
     */
    public function setTranNumber(\StructType\Field $tranNumber = null)
    {
        $this->TranNumber = $tranNumber;
        return $this;
    }
    /**
     * Get ProcessingCenterID value
     * @return \StructType\Field|null
     */
    public function getProcessingCenterID()
    {
        return $this->ProcessingCenterID;
    }
    /**
     * Set ProcessingCenterID value
     * @param \StructType\Field $processingCenterID
     * @return \StructType\ImportCCPayment
     */
    public function setProcessingCenterID(\StructType\Field $processingCenterID = null)
    {
        $this->ProcessingCenterID = $processingCenterID;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\ImportCCPaymentServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\ImportCCPaymentServiceCommands $serviceCommands
     * @return \StructType\ImportCCPayment
     */
    public function setServiceCommands(\StructType\ImportCCPaymentServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
