<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Export StructType
 * @subpackage Structs
 */
class Export extends AbstractStructBase
{
    /**
     * The topCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $topCount;
    /**
     * The includeHeaders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $includeHeaders;
    /**
     * The breakOnError
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $breakOnError;
    /**
     * The commands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommand
     */
    public $commands;
    /**
     * The filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfFilter
     */
    public $filters;
    /**
     * Constructor method for Export
     * @uses Export::setTopCount()
     * @uses Export::setIncludeHeaders()
     * @uses Export::setBreakOnError()
     * @uses Export::setCommands()
     * @uses Export::setFilters()
     * @param int $topCount
     * @param bool $includeHeaders
     * @param bool $breakOnError
     * @param \ArrayType\ArrayOfCommand $commands
     * @param \ArrayType\ArrayOfFilter $filters
     */
    public function __construct($topCount = null, $includeHeaders = null, $breakOnError = null, \ArrayType\ArrayOfCommand $commands = null, \ArrayType\ArrayOfFilter $filters = null)
    {
        $this
            ->setTopCount($topCount)
            ->setIncludeHeaders($includeHeaders)
            ->setBreakOnError($breakOnError)
            ->setCommands($commands)
            ->setFilters($filters);
    }
    /**
     * Get topCount value
     * @return int
     */
    public function getTopCount()
    {
        return $this->topCount;
    }
    /**
     * Set topCount value
     * @param int $topCount
     * @return \StructType\Export
     */
    public function setTopCount($topCount = null)
    {
        // validation for constraint: int
        if (!is_null($topCount) && !(is_int($topCount) || ctype_digit($topCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($topCount, true), gettype($topCount)), __LINE__);
        }
        $this->topCount = $topCount;
        return $this;
    }
    /**
     * Get includeHeaders value
     * @return bool
     */
    public function getIncludeHeaders()
    {
        return $this->includeHeaders;
    }
    /**
     * Set includeHeaders value
     * @param bool $includeHeaders
     * @return \StructType\Export
     */
    public function setIncludeHeaders($includeHeaders = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeHeaders) && !is_bool($includeHeaders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeHeaders, true), gettype($includeHeaders)), __LINE__);
        }
        $this->includeHeaders = $includeHeaders;
        return $this;
    }
    /**
     * Get breakOnError value
     * @return bool
     */
    public function getBreakOnError()
    {
        return $this->breakOnError;
    }
    /**
     * Set breakOnError value
     * @param bool $breakOnError
     * @return \StructType\Export
     */
    public function setBreakOnError($breakOnError = null)
    {
        // validation for constraint: boolean
        if (!is_null($breakOnError) && !is_bool($breakOnError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($breakOnError, true), gettype($breakOnError)), __LINE__);
        }
        $this->breakOnError = $breakOnError;
        return $this;
    }
    /**
     * Get commands value
     * @return \ArrayType\ArrayOfCommand|null
     */
    public function getCommands()
    {
        return $this->commands;
    }
    /**
     * Set commands value
     * @param \ArrayType\ArrayOfCommand $commands
     * @return \StructType\Export
     */
    public function setCommands(\ArrayType\ArrayOfCommand $commands = null)
    {
        $this->commands = $commands;
        return $this;
    }
    /**
     * Get filters value
     * @return \ArrayType\ArrayOfFilter|null
     */
    public function getFilters()
    {
        return $this->filters;
    }
    /**
     * Set filters value
     * @param \ArrayType\ArrayOfFilter $filters
     * @return \StructType\Export
     */
    public function setFilters(\ArrayType\ArrayOfFilter $filters = null)
    {
        $this->filters = $filters;
        return $this;
    }
}
