<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Details StructType
 * @subpackage Structs
 */
class Details extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The Configurable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Configurable;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Branch;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderType;
    /**
     * The OrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OrderNbr;
    /**
     * The LineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineNbr;
    /**
     * The AssociatedOrderLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AssociatedOrderLineNbr;
    /**
     * The GiftMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $GiftMessage;
    /**
     * The LineOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineOrder;
    /**
     * The LineType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineType;
    /**
     * The InvoiceNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InvoiceNbr;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Operation;
    /**
     * The InventoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $InventoryID;
    /**
     * The RelatedItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RelatedItems;
    /**
     * The SubstitutionRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SubstitutionRequired;
    /**
     * The EquipmentAction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EquipmentAction;
    /**
     * The EquipmentActionComment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EquipmentActionComment;
    /**
     * The TargetEquipmentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TargetEquipmentID;
    /**
     * The ModelEquipmentLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ModelEquipmentLineNbr;
    /**
     * The ComponentID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ComponentID;
    /**
     * The ComponentLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ComponentLineNbr;
    /**
     * The RelatedSvcDocNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RelatedSvcDocNbr;
    /**
     * The RequireAppointment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RequireAppointment;
    /**
     * The Subitem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Subitem;
    /**
     * The AutoCreateIssue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AutoCreateIssue;
    /**
     * The FreeItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FreeItem;
    /**
     * The Warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Warehouse;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Location;
    /**
     * The LineDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LineDescription;
    /**
     * The UOM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UOM;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Quantity;
    /**
     * The BaseOrderQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $BaseOrderQty;
    /**
     * The QtyOnOrders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyOnOrders;
    /**
     * The BlanketOpenQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $BlanketOpenQty;
    /**
     * The UnshippedQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnshippedQty;
    /**
     * The QtyOnShipments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $QtyOnShipments;
    /**
     * The OpenQty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OpenQty;
    /**
     * The UnitCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnitCost;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnitPrice;
    /**
     * The ManualPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ManualPrice;
    /**
     * The ExtPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExtPrice;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountPercent;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountAmount;
    /**
     * The DiscountCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountCode;
    /**
     * The DiscountSequence
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountSequence;
    /**
     * The ManualDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ManualDiscount;
    /**
     * The AutomaticDiscountsDisabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AutomaticDiscountsDisabled;
    /**
     * The DiscUnitPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscUnitPrice;
    /**
     * The AverageCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AverageCost;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Amount;
    /**
     * The SchedOrderDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SchedOrderDate;
    /**
     * The CustomerOrderNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CustomerOrderNbr;
    /**
     * The ShipToLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipToLocation;
    /**
     * The LocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LocationName;
    /**
     * The ShipVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipVia;
    /**
     * The FOB
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $FOB;
    /**
     * The ShippingTerms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippingTerms;
    /**
     * The ShippingZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippingZone;
    /**
     * The SchedShipmentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SchedShipmentDate;
    /**
     * The TaxZone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxZone;
    /**
     * The TermStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TermStartDate;
    /**
     * The TermEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TermEndDate;
    /**
     * The UnbilledAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnbilledAmount;
    /**
     * The RequestedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RequestedOn;
    /**
     * The ShipOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShipOn;
    /**
     * The ShippingRule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ShippingRule;
    /**
     * The UndershipThreshold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UndershipThreshold;
    /**
     * The OvershipThreshold
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $OvershipThreshold;
    /**
     * The Completed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Completed;
    /**
     * The MarkForPO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MarkForPO;
    /**
     * The POSource
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $POSource;
    /**
     * The POCreationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $POCreationDate;
    /**
     * The LotSerialNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $LotSerialNbr;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ExpirationDate;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ReasonCode;
    /**
     * The SalespersonID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SalespersonID;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TaxCategory;
    /**
     * The EntityUsageType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EntityUsageType;
    /**
     * The Commissionable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Commissionable;
    /**
     * The BlanketSORefNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $BlanketSORefNbr;
    /**
     * The AlternateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AlternateID;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Account;
    /**
     * The Subaccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Subaccount;
    /**
     * The ProjectTask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProjectTask;
    /**
     * The CostCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CostCode;
    /**
     * The UnitPriceForDR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $UnitPriceForDR;
    /**
     * The DiscountPercentForDR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DiscountPercentForDR;
    /**
     * The ROTOrRUTDeductible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ROTOrRUTDeductible;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ItemType;
    /**
     * The TypeOfWork
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $TypeOfWork;
    /**
     * The DeductibleAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $DeductibleAmount;
    /**
     * The MarkForProduction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $MarkForProduction;
    /**
     * The ProdOrderType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProdOrderType;
    /**
     * The ProductionNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ProductionNbr;
    /**
     * The EstimateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EstimateID;
    /**
     * The EstRevision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $EstRevision;
    /**
     * The ParentLineNbr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ParentLineNbr;
    /**
     * The IsSupplemental
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $IsSupplemental;
    /**
     * The ConfigKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ConfigKey;
    /**
     * The NoteText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $NoteText;
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Availability;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DetailsServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for Details
     * @uses Details::setDisplayName()
     * @uses Details::setConfigurable()
     * @uses Details::setBranch()
     * @uses Details::setOrderType()
     * @uses Details::setOrderNbr()
     * @uses Details::setLineNbr()
     * @uses Details::setAssociatedOrderLineNbr()
     * @uses Details::setGiftMessage()
     * @uses Details::setLineOrder()
     * @uses Details::setLineType()
     * @uses Details::setInvoiceNbr()
     * @uses Details::setOperation()
     * @uses Details::setInventoryID()
     * @uses Details::setRelatedItems()
     * @uses Details::setSubstitutionRequired()
     * @uses Details::setEquipmentAction()
     * @uses Details::setEquipmentActionComment()
     * @uses Details::setTargetEquipmentID()
     * @uses Details::setModelEquipmentLineNbr()
     * @uses Details::setComponentID()
     * @uses Details::setComponentLineNbr()
     * @uses Details::setRelatedSvcDocNbr()
     * @uses Details::setRequireAppointment()
     * @uses Details::setSubitem()
     * @uses Details::setAutoCreateIssue()
     * @uses Details::setFreeItem()
     * @uses Details::setWarehouse()
     * @uses Details::setLocation()
     * @uses Details::setLineDescription()
     * @uses Details::setUOM()
     * @uses Details::setQuantity()
     * @uses Details::setBaseOrderQty()
     * @uses Details::setQtyOnOrders()
     * @uses Details::setBlanketOpenQty()
     * @uses Details::setUnshippedQty()
     * @uses Details::setQtyOnShipments()
     * @uses Details::setOpenQty()
     * @uses Details::setUnitCost()
     * @uses Details::setUnitPrice()
     * @uses Details::setManualPrice()
     * @uses Details::setExtPrice()
     * @uses Details::setDiscountPercent()
     * @uses Details::setDiscountAmount()
     * @uses Details::setDiscountCode()
     * @uses Details::setDiscountSequence()
     * @uses Details::setManualDiscount()
     * @uses Details::setAutomaticDiscountsDisabled()
     * @uses Details::setDiscUnitPrice()
     * @uses Details::setAverageCost()
     * @uses Details::setAmount()
     * @uses Details::setSchedOrderDate()
     * @uses Details::setCustomerOrderNbr()
     * @uses Details::setShipToLocation()
     * @uses Details::setLocationName()
     * @uses Details::setShipVia()
     * @uses Details::setFOB()
     * @uses Details::setShippingTerms()
     * @uses Details::setShippingZone()
     * @uses Details::setSchedShipmentDate()
     * @uses Details::setTaxZone()
     * @uses Details::setTermStartDate()
     * @uses Details::setTermEndDate()
     * @uses Details::setUnbilledAmount()
     * @uses Details::setRequestedOn()
     * @uses Details::setShipOn()
     * @uses Details::setShippingRule()
     * @uses Details::setUndershipThreshold()
     * @uses Details::setOvershipThreshold()
     * @uses Details::setCompleted()
     * @uses Details::setMarkForPO()
     * @uses Details::setPOSource()
     * @uses Details::setPOCreationDate()
     * @uses Details::setLotSerialNbr()
     * @uses Details::setExpirationDate()
     * @uses Details::setReasonCode()
     * @uses Details::setSalespersonID()
     * @uses Details::setTaxCategory()
     * @uses Details::setEntityUsageType()
     * @uses Details::setCommissionable()
     * @uses Details::setBlanketSORefNbr()
     * @uses Details::setAlternateID()
     * @uses Details::setAccount()
     * @uses Details::setSubaccount()
     * @uses Details::setProjectTask()
     * @uses Details::setCostCode()
     * @uses Details::setUnitPriceForDR()
     * @uses Details::setDiscountPercentForDR()
     * @uses Details::setROTOrRUTDeductible()
     * @uses Details::setItemType()
     * @uses Details::setTypeOfWork()
     * @uses Details::setDeductibleAmount()
     * @uses Details::setMarkForProduction()
     * @uses Details::setProdOrderType()
     * @uses Details::setProductionNbr()
     * @uses Details::setEstimateID()
     * @uses Details::setEstRevision()
     * @uses Details::setParentLineNbr()
     * @uses Details::setIsSupplemental()
     * @uses Details::setConfigKey()
     * @uses Details::setNoteText()
     * @uses Details::setAvailability()
     * @uses Details::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $configurable
     * @param \StructType\Field $branch
     * @param \StructType\Field $orderType
     * @param \StructType\Field $orderNbr
     * @param \StructType\Field $lineNbr
     * @param \StructType\Field $associatedOrderLineNbr
     * @param \StructType\Field $giftMessage
     * @param \StructType\Field $lineOrder
     * @param \StructType\Field $lineType
     * @param \StructType\Field $invoiceNbr
     * @param \StructType\Field $operation
     * @param \StructType\Field $inventoryID
     * @param \StructType\Field $relatedItems
     * @param \StructType\Field $substitutionRequired
     * @param \StructType\Field $equipmentAction
     * @param \StructType\Field $equipmentActionComment
     * @param \StructType\Field $targetEquipmentID
     * @param \StructType\Field $modelEquipmentLineNbr
     * @param \StructType\Field $componentID
     * @param \StructType\Field $componentLineNbr
     * @param \StructType\Field $relatedSvcDocNbr
     * @param \StructType\Field $requireAppointment
     * @param \StructType\Field $subitem
     * @param \StructType\Field $autoCreateIssue
     * @param \StructType\Field $freeItem
     * @param \StructType\Field $warehouse
     * @param \StructType\Field $location
     * @param \StructType\Field $lineDescription
     * @param \StructType\Field $uOM
     * @param \StructType\Field $quantity
     * @param \StructType\Field $baseOrderQty
     * @param \StructType\Field $qtyOnOrders
     * @param \StructType\Field $blanketOpenQty
     * @param \StructType\Field $unshippedQty
     * @param \StructType\Field $qtyOnShipments
     * @param \StructType\Field $openQty
     * @param \StructType\Field $unitCost
     * @param \StructType\Field $unitPrice
     * @param \StructType\Field $manualPrice
     * @param \StructType\Field $extPrice
     * @param \StructType\Field $discountPercent
     * @param \StructType\Field $discountAmount
     * @param \StructType\Field $discountCode
     * @param \StructType\Field $discountSequence
     * @param \StructType\Field $manualDiscount
     * @param \StructType\Field $automaticDiscountsDisabled
     * @param \StructType\Field $discUnitPrice
     * @param \StructType\Field $averageCost
     * @param \StructType\Field $amount
     * @param \StructType\Field $schedOrderDate
     * @param \StructType\Field $customerOrderNbr
     * @param \StructType\Field $shipToLocation
     * @param \StructType\Field $locationName
     * @param \StructType\Field $shipVia
     * @param \StructType\Field $fOB
     * @param \StructType\Field $shippingTerms
     * @param \StructType\Field $shippingZone
     * @param \StructType\Field $schedShipmentDate
     * @param \StructType\Field $taxZone
     * @param \StructType\Field $termStartDate
     * @param \StructType\Field $termEndDate
     * @param \StructType\Field $unbilledAmount
     * @param \StructType\Field $requestedOn
     * @param \StructType\Field $shipOn
     * @param \StructType\Field $shippingRule
     * @param \StructType\Field $undershipThreshold
     * @param \StructType\Field $overshipThreshold
     * @param \StructType\Field $completed
     * @param \StructType\Field $markForPO
     * @param \StructType\Field $pOSource
     * @param \StructType\Field $pOCreationDate
     * @param \StructType\Field $lotSerialNbr
     * @param \StructType\Field $expirationDate
     * @param \StructType\Field $reasonCode
     * @param \StructType\Field $salespersonID
     * @param \StructType\Field $taxCategory
     * @param \StructType\Field $entityUsageType
     * @param \StructType\Field $commissionable
     * @param \StructType\Field $blanketSORefNbr
     * @param \StructType\Field $alternateID
     * @param \StructType\Field $account
     * @param \StructType\Field $subaccount
     * @param \StructType\Field $projectTask
     * @param \StructType\Field $costCode
     * @param \StructType\Field $unitPriceForDR
     * @param \StructType\Field $discountPercentForDR
     * @param \StructType\Field $rOTOrRUTDeductible
     * @param \StructType\Field $itemType
     * @param \StructType\Field $typeOfWork
     * @param \StructType\Field $deductibleAmount
     * @param \StructType\Field $markForProduction
     * @param \StructType\Field $prodOrderType
     * @param \StructType\Field $productionNbr
     * @param \StructType\Field $estimateID
     * @param \StructType\Field $estRevision
     * @param \StructType\Field $parentLineNbr
     * @param \StructType\Field $isSupplemental
     * @param \StructType\Field $configKey
     * @param \StructType\Field $noteText
     * @param \StructType\Field $availability
     * @param \StructType\DetailsServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $configurable = null, \StructType\Field $branch = null, \StructType\Field $orderType = null, \StructType\Field $orderNbr = null, \StructType\Field $lineNbr = null, \StructType\Field $associatedOrderLineNbr = null, \StructType\Field $giftMessage = null, \StructType\Field $lineOrder = null, \StructType\Field $lineType = null, \StructType\Field $invoiceNbr = null, \StructType\Field $operation = null, \StructType\Field $inventoryID = null, \StructType\Field $relatedItems = null, \StructType\Field $substitutionRequired = null, \StructType\Field $equipmentAction = null, \StructType\Field $equipmentActionComment = null, \StructType\Field $targetEquipmentID = null, \StructType\Field $modelEquipmentLineNbr = null, \StructType\Field $componentID = null, \StructType\Field $componentLineNbr = null, \StructType\Field $relatedSvcDocNbr = null, \StructType\Field $requireAppointment = null, \StructType\Field $subitem = null, \StructType\Field $autoCreateIssue = null, \StructType\Field $freeItem = null, \StructType\Field $warehouse = null, \StructType\Field $location = null, \StructType\Field $lineDescription = null, \StructType\Field $uOM = null, \StructType\Field $quantity = null, \StructType\Field $baseOrderQty = null, \StructType\Field $qtyOnOrders = null, \StructType\Field $blanketOpenQty = null, \StructType\Field $unshippedQty = null, \StructType\Field $qtyOnShipments = null, \StructType\Field $openQty = null, \StructType\Field $unitCost = null, \StructType\Field $unitPrice = null, \StructType\Field $manualPrice = null, \StructType\Field $extPrice = null, \StructType\Field $discountPercent = null, \StructType\Field $discountAmount = null, \StructType\Field $discountCode = null, \StructType\Field $discountSequence = null, \StructType\Field $manualDiscount = null, \StructType\Field $automaticDiscountsDisabled = null, \StructType\Field $discUnitPrice = null, \StructType\Field $averageCost = null, \StructType\Field $amount = null, \StructType\Field $schedOrderDate = null, \StructType\Field $customerOrderNbr = null, \StructType\Field $shipToLocation = null, \StructType\Field $locationName = null, \StructType\Field $shipVia = null, \StructType\Field $fOB = null, \StructType\Field $shippingTerms = null, \StructType\Field $shippingZone = null, \StructType\Field $schedShipmentDate = null, \StructType\Field $taxZone = null, \StructType\Field $termStartDate = null, \StructType\Field $termEndDate = null, \StructType\Field $unbilledAmount = null, \StructType\Field $requestedOn = null, \StructType\Field $shipOn = null, \StructType\Field $shippingRule = null, \StructType\Field $undershipThreshold = null, \StructType\Field $overshipThreshold = null, \StructType\Field $completed = null, \StructType\Field $markForPO = null, \StructType\Field $pOSource = null, \StructType\Field $pOCreationDate = null, \StructType\Field $lotSerialNbr = null, \StructType\Field $expirationDate = null, \StructType\Field $reasonCode = null, \StructType\Field $salespersonID = null, \StructType\Field $taxCategory = null, \StructType\Field $entityUsageType = null, \StructType\Field $commissionable = null, \StructType\Field $blanketSORefNbr = null, \StructType\Field $alternateID = null, \StructType\Field $account = null, \StructType\Field $subaccount = null, \StructType\Field $projectTask = null, \StructType\Field $costCode = null, \StructType\Field $unitPriceForDR = null, \StructType\Field $discountPercentForDR = null, \StructType\Field $rOTOrRUTDeductible = null, \StructType\Field $itemType = null, \StructType\Field $typeOfWork = null, \StructType\Field $deductibleAmount = null, \StructType\Field $markForProduction = null, \StructType\Field $prodOrderType = null, \StructType\Field $productionNbr = null, \StructType\Field $estimateID = null, \StructType\Field $estRevision = null, \StructType\Field $parentLineNbr = null, \StructType\Field $isSupplemental = null, \StructType\Field $configKey = null, \StructType\Field $noteText = null, \StructType\Field $availability = null, \StructType\DetailsServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setConfigurable($configurable)
            ->setBranch($branch)
            ->setOrderType($orderType)
            ->setOrderNbr($orderNbr)
            ->setLineNbr($lineNbr)
            ->setAssociatedOrderLineNbr($associatedOrderLineNbr)
            ->setGiftMessage($giftMessage)
            ->setLineOrder($lineOrder)
            ->setLineType($lineType)
            ->setInvoiceNbr($invoiceNbr)
            ->setOperation($operation)
            ->setInventoryID($inventoryID)
            ->setRelatedItems($relatedItems)
            ->setSubstitutionRequired($substitutionRequired)
            ->setEquipmentAction($equipmentAction)
            ->setEquipmentActionComment($equipmentActionComment)
            ->setTargetEquipmentID($targetEquipmentID)
            ->setModelEquipmentLineNbr($modelEquipmentLineNbr)
            ->setComponentID($componentID)
            ->setComponentLineNbr($componentLineNbr)
            ->setRelatedSvcDocNbr($relatedSvcDocNbr)
            ->setRequireAppointment($requireAppointment)
            ->setSubitem($subitem)
            ->setAutoCreateIssue($autoCreateIssue)
            ->setFreeItem($freeItem)
            ->setWarehouse($warehouse)
            ->setLocation($location)
            ->setLineDescription($lineDescription)
            ->setUOM($uOM)
            ->setQuantity($quantity)
            ->setBaseOrderQty($baseOrderQty)
            ->setQtyOnOrders($qtyOnOrders)
            ->setBlanketOpenQty($blanketOpenQty)
            ->setUnshippedQty($unshippedQty)
            ->setQtyOnShipments($qtyOnShipments)
            ->setOpenQty($openQty)
            ->setUnitCost($unitCost)
            ->setUnitPrice($unitPrice)
            ->setManualPrice($manualPrice)
            ->setExtPrice($extPrice)
            ->setDiscountPercent($discountPercent)
            ->setDiscountAmount($discountAmount)
            ->setDiscountCode($discountCode)
            ->setDiscountSequence($discountSequence)
            ->setManualDiscount($manualDiscount)
            ->setAutomaticDiscountsDisabled($automaticDiscountsDisabled)
            ->setDiscUnitPrice($discUnitPrice)
            ->setAverageCost($averageCost)
            ->setAmount($amount)
            ->setSchedOrderDate($schedOrderDate)
            ->setCustomerOrderNbr($customerOrderNbr)
            ->setShipToLocation($shipToLocation)
            ->setLocationName($locationName)
            ->setShipVia($shipVia)
            ->setFOB($fOB)
            ->setShippingTerms($shippingTerms)
            ->setShippingZone($shippingZone)
            ->setSchedShipmentDate($schedShipmentDate)
            ->setTaxZone($taxZone)
            ->setTermStartDate($termStartDate)
            ->setTermEndDate($termEndDate)
            ->setUnbilledAmount($unbilledAmount)
            ->setRequestedOn($requestedOn)
            ->setShipOn($shipOn)
            ->setShippingRule($shippingRule)
            ->setUndershipThreshold($undershipThreshold)
            ->setOvershipThreshold($overshipThreshold)
            ->setCompleted($completed)
            ->setMarkForPO($markForPO)
            ->setPOSource($pOSource)
            ->setPOCreationDate($pOCreationDate)
            ->setLotSerialNbr($lotSerialNbr)
            ->setExpirationDate($expirationDate)
            ->setReasonCode($reasonCode)
            ->setSalespersonID($salespersonID)
            ->setTaxCategory($taxCategory)
            ->setEntityUsageType($entityUsageType)
            ->setCommissionable($commissionable)
            ->setBlanketSORefNbr($blanketSORefNbr)
            ->setAlternateID($alternateID)
            ->setAccount($account)
            ->setSubaccount($subaccount)
            ->setProjectTask($projectTask)
            ->setCostCode($costCode)
            ->setUnitPriceForDR($unitPriceForDR)
            ->setDiscountPercentForDR($discountPercentForDR)
            ->setROTOrRUTDeductible($rOTOrRUTDeductible)
            ->setItemType($itemType)
            ->setTypeOfWork($typeOfWork)
            ->setDeductibleAmount($deductibleAmount)
            ->setMarkForProduction($markForProduction)
            ->setProdOrderType($prodOrderType)
            ->setProductionNbr($productionNbr)
            ->setEstimateID($estimateID)
            ->setEstRevision($estRevision)
            ->setParentLineNbr($parentLineNbr)
            ->setIsSupplemental($isSupplemental)
            ->setConfigKey($configKey)
            ->setNoteText($noteText)
            ->setAvailability($availability)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Details
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get Configurable value
     * @return \StructType\Field|null
     */
    public function getConfigurable()
    {
        return $this->Configurable;
    }
    /**
     * Set Configurable value
     * @param \StructType\Field $configurable
     * @return \StructType\Details
     */
    public function setConfigurable(\StructType\Field $configurable = null)
    {
        $this->Configurable = $configurable;
        return $this;
    }
    /**
     * Get Branch value
     * @return \StructType\Field|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * Set Branch value
     * @param \StructType\Field $branch
     * @return \StructType\Details
     */
    public function setBranch(\StructType\Field $branch = null)
    {
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Get OrderType value
     * @return \StructType\Field|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param \StructType\Field $orderType
     * @return \StructType\Details
     */
    public function setOrderType(\StructType\Field $orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderNbr value
     * @return \StructType\Field|null
     */
    public function getOrderNbr()
    {
        return $this->OrderNbr;
    }
    /**
     * Set OrderNbr value
     * @param \StructType\Field $orderNbr
     * @return \StructType\Details
     */
    public function setOrderNbr(\StructType\Field $orderNbr = null)
    {
        $this->OrderNbr = $orderNbr;
        return $this;
    }
    /**
     * Get LineNbr value
     * @return \StructType\Field|null
     */
    public function getLineNbr()
    {
        return $this->LineNbr;
    }
    /**
     * Set LineNbr value
     * @param \StructType\Field $lineNbr
     * @return \StructType\Details
     */
    public function setLineNbr(\StructType\Field $lineNbr = null)
    {
        $this->LineNbr = $lineNbr;
        return $this;
    }
    /**
     * Get AssociatedOrderLineNbr value
     * @return \StructType\Field|null
     */
    public function getAssociatedOrderLineNbr()
    {
        return $this->AssociatedOrderLineNbr;
    }
    /**
     * Set AssociatedOrderLineNbr value
     * @param \StructType\Field $associatedOrderLineNbr
     * @return \StructType\Details
     */
    public function setAssociatedOrderLineNbr(\StructType\Field $associatedOrderLineNbr = null)
    {
        $this->AssociatedOrderLineNbr = $associatedOrderLineNbr;
        return $this;
    }
    /**
     * Get GiftMessage value
     * @return \StructType\Field|null
     */
    public function getGiftMessage()
    {
        return $this->GiftMessage;
    }
    /**
     * Set GiftMessage value
     * @param \StructType\Field $giftMessage
     * @return \StructType\Details
     */
    public function setGiftMessage(\StructType\Field $giftMessage = null)
    {
        $this->GiftMessage = $giftMessage;
        return $this;
    }
    /**
     * Get LineOrder value
     * @return \StructType\Field|null
     */
    public function getLineOrder()
    {
        return $this->LineOrder;
    }
    /**
     * Set LineOrder value
     * @param \StructType\Field $lineOrder
     * @return \StructType\Details
     */
    public function setLineOrder(\StructType\Field $lineOrder = null)
    {
        $this->LineOrder = $lineOrder;
        return $this;
    }
    /**
     * Get LineType value
     * @return \StructType\Field|null
     */
    public function getLineType()
    {
        return $this->LineType;
    }
    /**
     * Set LineType value
     * @param \StructType\Field $lineType
     * @return \StructType\Details
     */
    public function setLineType(\StructType\Field $lineType = null)
    {
        $this->LineType = $lineType;
        return $this;
    }
    /**
     * Get InvoiceNbr value
     * @return \StructType\Field|null
     */
    public function getInvoiceNbr()
    {
        return $this->InvoiceNbr;
    }
    /**
     * Set InvoiceNbr value
     * @param \StructType\Field $invoiceNbr
     * @return \StructType\Details
     */
    public function setInvoiceNbr(\StructType\Field $invoiceNbr = null)
    {
        $this->InvoiceNbr = $invoiceNbr;
        return $this;
    }
    /**
     * Get Operation value
     * @return \StructType\Field|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @param \StructType\Field $operation
     * @return \StructType\Details
     */
    public function setOperation(\StructType\Field $operation = null)
    {
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get InventoryID value
     * @return \StructType\Field|null
     */
    public function getInventoryID()
    {
        return $this->InventoryID;
    }
    /**
     * Set InventoryID value
     * @param \StructType\Field $inventoryID
     * @return \StructType\Details
     */
    public function setInventoryID(\StructType\Field $inventoryID = null)
    {
        $this->InventoryID = $inventoryID;
        return $this;
    }
    /**
     * Get RelatedItems value
     * @return \StructType\Field|null
     */
    public function getRelatedItems()
    {
        return $this->RelatedItems;
    }
    /**
     * Set RelatedItems value
     * @param \StructType\Field $relatedItems
     * @return \StructType\Details
     */
    public function setRelatedItems(\StructType\Field $relatedItems = null)
    {
        $this->RelatedItems = $relatedItems;
        return $this;
    }
    /**
     * Get SubstitutionRequired value
     * @return \StructType\Field|null
     */
    public function getSubstitutionRequired()
    {
        return $this->SubstitutionRequired;
    }
    /**
     * Set SubstitutionRequired value
     * @param \StructType\Field $substitutionRequired
     * @return \StructType\Details
     */
    public function setSubstitutionRequired(\StructType\Field $substitutionRequired = null)
    {
        $this->SubstitutionRequired = $substitutionRequired;
        return $this;
    }
    /**
     * Get EquipmentAction value
     * @return \StructType\Field|null
     */
    public function getEquipmentAction()
    {
        return $this->EquipmentAction;
    }
    /**
     * Set EquipmentAction value
     * @param \StructType\Field $equipmentAction
     * @return \StructType\Details
     */
    public function setEquipmentAction(\StructType\Field $equipmentAction = null)
    {
        $this->EquipmentAction = $equipmentAction;
        return $this;
    }
    /**
     * Get EquipmentActionComment value
     * @return \StructType\Field|null
     */
    public function getEquipmentActionComment()
    {
        return $this->EquipmentActionComment;
    }
    /**
     * Set EquipmentActionComment value
     * @param \StructType\Field $equipmentActionComment
     * @return \StructType\Details
     */
    public function setEquipmentActionComment(\StructType\Field $equipmentActionComment = null)
    {
        $this->EquipmentActionComment = $equipmentActionComment;
        return $this;
    }
    /**
     * Get TargetEquipmentID value
     * @return \StructType\Field|null
     */
    public function getTargetEquipmentID()
    {
        return $this->TargetEquipmentID;
    }
    /**
     * Set TargetEquipmentID value
     * @param \StructType\Field $targetEquipmentID
     * @return \StructType\Details
     */
    public function setTargetEquipmentID(\StructType\Field $targetEquipmentID = null)
    {
        $this->TargetEquipmentID = $targetEquipmentID;
        return $this;
    }
    /**
     * Get ModelEquipmentLineNbr value
     * @return \StructType\Field|null
     */
    public function getModelEquipmentLineNbr()
    {
        return $this->ModelEquipmentLineNbr;
    }
    /**
     * Set ModelEquipmentLineNbr value
     * @param \StructType\Field $modelEquipmentLineNbr
     * @return \StructType\Details
     */
    public function setModelEquipmentLineNbr(\StructType\Field $modelEquipmentLineNbr = null)
    {
        $this->ModelEquipmentLineNbr = $modelEquipmentLineNbr;
        return $this;
    }
    /**
     * Get ComponentID value
     * @return \StructType\Field|null
     */
    public function getComponentID()
    {
        return $this->ComponentID;
    }
    /**
     * Set ComponentID value
     * @param \StructType\Field $componentID
     * @return \StructType\Details
     */
    public function setComponentID(\StructType\Field $componentID = null)
    {
        $this->ComponentID = $componentID;
        return $this;
    }
    /**
     * Get ComponentLineNbr value
     * @return \StructType\Field|null
     */
    public function getComponentLineNbr()
    {
        return $this->ComponentLineNbr;
    }
    /**
     * Set ComponentLineNbr value
     * @param \StructType\Field $componentLineNbr
     * @return \StructType\Details
     */
    public function setComponentLineNbr(\StructType\Field $componentLineNbr = null)
    {
        $this->ComponentLineNbr = $componentLineNbr;
        return $this;
    }
    /**
     * Get RelatedSvcDocNbr value
     * @return \StructType\Field|null
     */
    public function getRelatedSvcDocNbr()
    {
        return $this->RelatedSvcDocNbr;
    }
    /**
     * Set RelatedSvcDocNbr value
     * @param \StructType\Field $relatedSvcDocNbr
     * @return \StructType\Details
     */
    public function setRelatedSvcDocNbr(\StructType\Field $relatedSvcDocNbr = null)
    {
        $this->RelatedSvcDocNbr = $relatedSvcDocNbr;
        return $this;
    }
    /**
     * Get RequireAppointment value
     * @return \StructType\Field|null
     */
    public function getRequireAppointment()
    {
        return $this->RequireAppointment;
    }
    /**
     * Set RequireAppointment value
     * @param \StructType\Field $requireAppointment
     * @return \StructType\Details
     */
    public function setRequireAppointment(\StructType\Field $requireAppointment = null)
    {
        $this->RequireAppointment = $requireAppointment;
        return $this;
    }
    /**
     * Get Subitem value
     * @return \StructType\Field|null
     */
    public function getSubitem()
    {
        return $this->Subitem;
    }
    /**
     * Set Subitem value
     * @param \StructType\Field $subitem
     * @return \StructType\Details
     */
    public function setSubitem(\StructType\Field $subitem = null)
    {
        $this->Subitem = $subitem;
        return $this;
    }
    /**
     * Get AutoCreateIssue value
     * @return \StructType\Field|null
     */
    public function getAutoCreateIssue()
    {
        return $this->AutoCreateIssue;
    }
    /**
     * Set AutoCreateIssue value
     * @param \StructType\Field $autoCreateIssue
     * @return \StructType\Details
     */
    public function setAutoCreateIssue(\StructType\Field $autoCreateIssue = null)
    {
        $this->AutoCreateIssue = $autoCreateIssue;
        return $this;
    }
    /**
     * Get FreeItem value
     * @return \StructType\Field|null
     */
    public function getFreeItem()
    {
        return $this->FreeItem;
    }
    /**
     * Set FreeItem value
     * @param \StructType\Field $freeItem
     * @return \StructType\Details
     */
    public function setFreeItem(\StructType\Field $freeItem = null)
    {
        $this->FreeItem = $freeItem;
        return $this;
    }
    /**
     * Get Warehouse value
     * @return \StructType\Field|null
     */
    public function getWarehouse()
    {
        return $this->Warehouse;
    }
    /**
     * Set Warehouse value
     * @param \StructType\Field $warehouse
     * @return \StructType\Details
     */
    public function setWarehouse(\StructType\Field $warehouse = null)
    {
        $this->Warehouse = $warehouse;
        return $this;
    }
    /**
     * Get Location value
     * @return \StructType\Field|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \StructType\Field $location
     * @return \StructType\Details
     */
    public function setLocation(\StructType\Field $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get LineDescription value
     * @return \StructType\Field|null
     */
    public function getLineDescription()
    {
        return $this->LineDescription;
    }
    /**
     * Set LineDescription value
     * @param \StructType\Field $lineDescription
     * @return \StructType\Details
     */
    public function setLineDescription(\StructType\Field $lineDescription = null)
    {
        $this->LineDescription = $lineDescription;
        return $this;
    }
    /**
     * Get UOM value
     * @return \StructType\Field|null
     */
    public function getUOM()
    {
        return $this->UOM;
    }
    /**
     * Set UOM value
     * @param \StructType\Field $uOM
     * @return \StructType\Details
     */
    public function setUOM(\StructType\Field $uOM = null)
    {
        $this->UOM = $uOM;
        return $this;
    }
    /**
     * Get Quantity value
     * @return \StructType\Field|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param \StructType\Field $quantity
     * @return \StructType\Details
     */
    public function setQuantity(\StructType\Field $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get BaseOrderQty value
     * @return \StructType\Field|null
     */
    public function getBaseOrderQty()
    {
        return $this->BaseOrderQty;
    }
    /**
     * Set BaseOrderQty value
     * @param \StructType\Field $baseOrderQty
     * @return \StructType\Details
     */
    public function setBaseOrderQty(\StructType\Field $baseOrderQty = null)
    {
        $this->BaseOrderQty = $baseOrderQty;
        return $this;
    }
    /**
     * Get QtyOnOrders value
     * @return \StructType\Field|null
     */
    public function getQtyOnOrders()
    {
        return $this->QtyOnOrders;
    }
    /**
     * Set QtyOnOrders value
     * @param \StructType\Field $qtyOnOrders
     * @return \StructType\Details
     */
    public function setQtyOnOrders(\StructType\Field $qtyOnOrders = null)
    {
        $this->QtyOnOrders = $qtyOnOrders;
        return $this;
    }
    /**
     * Get BlanketOpenQty value
     * @return \StructType\Field|null
     */
    public function getBlanketOpenQty()
    {
        return $this->BlanketOpenQty;
    }
    /**
     * Set BlanketOpenQty value
     * @param \StructType\Field $blanketOpenQty
     * @return \StructType\Details
     */
    public function setBlanketOpenQty(\StructType\Field $blanketOpenQty = null)
    {
        $this->BlanketOpenQty = $blanketOpenQty;
        return $this;
    }
    /**
     * Get UnshippedQty value
     * @return \StructType\Field|null
     */
    public function getUnshippedQty()
    {
        return $this->UnshippedQty;
    }
    /**
     * Set UnshippedQty value
     * @param \StructType\Field $unshippedQty
     * @return \StructType\Details
     */
    public function setUnshippedQty(\StructType\Field $unshippedQty = null)
    {
        $this->UnshippedQty = $unshippedQty;
        return $this;
    }
    /**
     * Get QtyOnShipments value
     * @return \StructType\Field|null
     */
    public function getQtyOnShipments()
    {
        return $this->QtyOnShipments;
    }
    /**
     * Set QtyOnShipments value
     * @param \StructType\Field $qtyOnShipments
     * @return \StructType\Details
     */
    public function setQtyOnShipments(\StructType\Field $qtyOnShipments = null)
    {
        $this->QtyOnShipments = $qtyOnShipments;
        return $this;
    }
    /**
     * Get OpenQty value
     * @return \StructType\Field|null
     */
    public function getOpenQty()
    {
        return $this->OpenQty;
    }
    /**
     * Set OpenQty value
     * @param \StructType\Field $openQty
     * @return \StructType\Details
     */
    public function setOpenQty(\StructType\Field $openQty = null)
    {
        $this->OpenQty = $openQty;
        return $this;
    }
    /**
     * Get UnitCost value
     * @return \StructType\Field|null
     */
    public function getUnitCost()
    {
        return $this->UnitCost;
    }
    /**
     * Set UnitCost value
     * @param \StructType\Field $unitCost
     * @return \StructType\Details
     */
    public function setUnitCost(\StructType\Field $unitCost = null)
    {
        $this->UnitCost = $unitCost;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return \StructType\Field|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param \StructType\Field $unitPrice
     * @return \StructType\Details
     */
    public function setUnitPrice(\StructType\Field $unitPrice = null)
    {
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get ManualPrice value
     * @return \StructType\Field|null
     */
    public function getManualPrice()
    {
        return $this->ManualPrice;
    }
    /**
     * Set ManualPrice value
     * @param \StructType\Field $manualPrice
     * @return \StructType\Details
     */
    public function setManualPrice(\StructType\Field $manualPrice = null)
    {
        $this->ManualPrice = $manualPrice;
        return $this;
    }
    /**
     * Get ExtPrice value
     * @return \StructType\Field|null
     */
    public function getExtPrice()
    {
        return $this->ExtPrice;
    }
    /**
     * Set ExtPrice value
     * @param \StructType\Field $extPrice
     * @return \StructType\Details
     */
    public function setExtPrice(\StructType\Field $extPrice = null)
    {
        $this->ExtPrice = $extPrice;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return \StructType\Field|null
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param \StructType\Field $discountPercent
     * @return \StructType\Details
     */
    public function setDiscountPercent(\StructType\Field $discountPercent = null)
    {
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return \StructType\Field|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param \StructType\Field $discountAmount
     * @return \StructType\Details
     */
    public function setDiscountAmount(\StructType\Field $discountAmount = null)
    {
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get DiscountCode value
     * @return \StructType\Field|null
     */
    public function getDiscountCode()
    {
        return $this->DiscountCode;
    }
    /**
     * Set DiscountCode value
     * @param \StructType\Field $discountCode
     * @return \StructType\Details
     */
    public function setDiscountCode(\StructType\Field $discountCode = null)
    {
        $this->DiscountCode = $discountCode;
        return $this;
    }
    /**
     * Get DiscountSequence value
     * @return \StructType\Field|null
     */
    public function getDiscountSequence()
    {
        return $this->DiscountSequence;
    }
    /**
     * Set DiscountSequence value
     * @param \StructType\Field $discountSequence
     * @return \StructType\Details
     */
    public function setDiscountSequence(\StructType\Field $discountSequence = null)
    {
        $this->DiscountSequence = $discountSequence;
        return $this;
    }
    /**
     * Get ManualDiscount value
     * @return \StructType\Field|null
     */
    public function getManualDiscount()
    {
        return $this->ManualDiscount;
    }
    /**
     * Set ManualDiscount value
     * @param \StructType\Field $manualDiscount
     * @return \StructType\Details
     */
    public function setManualDiscount(\StructType\Field $manualDiscount = null)
    {
        $this->ManualDiscount = $manualDiscount;
        return $this;
    }
    /**
     * Get AutomaticDiscountsDisabled value
     * @return \StructType\Field|null
     */
    public function getAutomaticDiscountsDisabled()
    {
        return $this->AutomaticDiscountsDisabled;
    }
    /**
     * Set AutomaticDiscountsDisabled value
     * @param \StructType\Field $automaticDiscountsDisabled
     * @return \StructType\Details
     */
    public function setAutomaticDiscountsDisabled(\StructType\Field $automaticDiscountsDisabled = null)
    {
        $this->AutomaticDiscountsDisabled = $automaticDiscountsDisabled;
        return $this;
    }
    /**
     * Get DiscUnitPrice value
     * @return \StructType\Field|null
     */
    public function getDiscUnitPrice()
    {
        return $this->DiscUnitPrice;
    }
    /**
     * Set DiscUnitPrice value
     * @param \StructType\Field $discUnitPrice
     * @return \StructType\Details
     */
    public function setDiscUnitPrice(\StructType\Field $discUnitPrice = null)
    {
        $this->DiscUnitPrice = $discUnitPrice;
        return $this;
    }
    /**
     * Get AverageCost value
     * @return \StructType\Field|null
     */
    public function getAverageCost()
    {
        return $this->AverageCost;
    }
    /**
     * Set AverageCost value
     * @param \StructType\Field $averageCost
     * @return \StructType\Details
     */
    public function setAverageCost(\StructType\Field $averageCost = null)
    {
        $this->AverageCost = $averageCost;
        return $this;
    }
    /**
     * Get Amount value
     * @return \StructType\Field|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\Field $amount
     * @return \StructType\Details
     */
    public function setAmount(\StructType\Field $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get SchedOrderDate value
     * @return \StructType\Field|null
     */
    public function getSchedOrderDate()
    {
        return $this->SchedOrderDate;
    }
    /**
     * Set SchedOrderDate value
     * @param \StructType\Field $schedOrderDate
     * @return \StructType\Details
     */
    public function setSchedOrderDate(\StructType\Field $schedOrderDate = null)
    {
        $this->SchedOrderDate = $schedOrderDate;
        return $this;
    }
    /**
     * Get CustomerOrderNbr value
     * @return \StructType\Field|null
     */
    public function getCustomerOrderNbr()
    {
        return $this->CustomerOrderNbr;
    }
    /**
     * Set CustomerOrderNbr value
     * @param \StructType\Field $customerOrderNbr
     * @return \StructType\Details
     */
    public function setCustomerOrderNbr(\StructType\Field $customerOrderNbr = null)
    {
        $this->CustomerOrderNbr = $customerOrderNbr;
        return $this;
    }
    /**
     * Get ShipToLocation value
     * @return \StructType\Field|null
     */
    public function getShipToLocation()
    {
        return $this->ShipToLocation;
    }
    /**
     * Set ShipToLocation value
     * @param \StructType\Field $shipToLocation
     * @return \StructType\Details
     */
    public function setShipToLocation(\StructType\Field $shipToLocation = null)
    {
        $this->ShipToLocation = $shipToLocation;
        return $this;
    }
    /**
     * Get LocationName value
     * @return \StructType\Field|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param \StructType\Field $locationName
     * @return \StructType\Details
     */
    public function setLocationName(\StructType\Field $locationName = null)
    {
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get ShipVia value
     * @return \StructType\Field|null
     */
    public function getShipVia()
    {
        return $this->ShipVia;
    }
    /**
     * Set ShipVia value
     * @param \StructType\Field $shipVia
     * @return \StructType\Details
     */
    public function setShipVia(\StructType\Field $shipVia = null)
    {
        $this->ShipVia = $shipVia;
        return $this;
    }
    /**
     * Get FOB value
     * @return \StructType\Field|null
     */
    public function getFOB()
    {
        return $this->FOB;
    }
    /**
     * Set FOB value
     * @param \StructType\Field $fOB
     * @return \StructType\Details
     */
    public function setFOB(\StructType\Field $fOB = null)
    {
        $this->FOB = $fOB;
        return $this;
    }
    /**
     * Get ShippingTerms value
     * @return \StructType\Field|null
     */
    public function getShippingTerms()
    {
        return $this->ShippingTerms;
    }
    /**
     * Set ShippingTerms value
     * @param \StructType\Field $shippingTerms
     * @return \StructType\Details
     */
    public function setShippingTerms(\StructType\Field $shippingTerms = null)
    {
        $this->ShippingTerms = $shippingTerms;
        return $this;
    }
    /**
     * Get ShippingZone value
     * @return \StructType\Field|null
     */
    public function getShippingZone()
    {
        return $this->ShippingZone;
    }
    /**
     * Set ShippingZone value
     * @param \StructType\Field $shippingZone
     * @return \StructType\Details
     */
    public function setShippingZone(\StructType\Field $shippingZone = null)
    {
        $this->ShippingZone = $shippingZone;
        return $this;
    }
    /**
     * Get SchedShipmentDate value
     * @return \StructType\Field|null
     */
    public function getSchedShipmentDate()
    {
        return $this->SchedShipmentDate;
    }
    /**
     * Set SchedShipmentDate value
     * @param \StructType\Field $schedShipmentDate
     * @return \StructType\Details
     */
    public function setSchedShipmentDate(\StructType\Field $schedShipmentDate = null)
    {
        $this->SchedShipmentDate = $schedShipmentDate;
        return $this;
    }
    /**
     * Get TaxZone value
     * @return \StructType\Field|null
     */
    public function getTaxZone()
    {
        return $this->TaxZone;
    }
    /**
     * Set TaxZone value
     * @param \StructType\Field $taxZone
     * @return \StructType\Details
     */
    public function setTaxZone(\StructType\Field $taxZone = null)
    {
        $this->TaxZone = $taxZone;
        return $this;
    }
    /**
     * Get TermStartDate value
     * @return \StructType\Field|null
     */
    public function getTermStartDate()
    {
        return $this->TermStartDate;
    }
    /**
     * Set TermStartDate value
     * @param \StructType\Field $termStartDate
     * @return \StructType\Details
     */
    public function setTermStartDate(\StructType\Field $termStartDate = null)
    {
        $this->TermStartDate = $termStartDate;
        return $this;
    }
    /**
     * Get TermEndDate value
     * @return \StructType\Field|null
     */
    public function getTermEndDate()
    {
        return $this->TermEndDate;
    }
    /**
     * Set TermEndDate value
     * @param \StructType\Field $termEndDate
     * @return \StructType\Details
     */
    public function setTermEndDate(\StructType\Field $termEndDate = null)
    {
        $this->TermEndDate = $termEndDate;
        return $this;
    }
    /**
     * Get UnbilledAmount value
     * @return \StructType\Field|null
     */
    public function getUnbilledAmount()
    {
        return $this->UnbilledAmount;
    }
    /**
     * Set UnbilledAmount value
     * @param \StructType\Field $unbilledAmount
     * @return \StructType\Details
     */
    public function setUnbilledAmount(\StructType\Field $unbilledAmount = null)
    {
        $this->UnbilledAmount = $unbilledAmount;
        return $this;
    }
    /**
     * Get RequestedOn value
     * @return \StructType\Field|null
     */
    public function getRequestedOn()
    {
        return $this->RequestedOn;
    }
    /**
     * Set RequestedOn value
     * @param \StructType\Field $requestedOn
     * @return \StructType\Details
     */
    public function setRequestedOn(\StructType\Field $requestedOn = null)
    {
        $this->RequestedOn = $requestedOn;
        return $this;
    }
    /**
     * Get ShipOn value
     * @return \StructType\Field|null
     */
    public function getShipOn()
    {
        return $this->ShipOn;
    }
    /**
     * Set ShipOn value
     * @param \StructType\Field $shipOn
     * @return \StructType\Details
     */
    public function setShipOn(\StructType\Field $shipOn = null)
    {
        $this->ShipOn = $shipOn;
        return $this;
    }
    /**
     * Get ShippingRule value
     * @return \StructType\Field|null
     */
    public function getShippingRule()
    {
        return $this->ShippingRule;
    }
    /**
     * Set ShippingRule value
     * @param \StructType\Field $shippingRule
     * @return \StructType\Details
     */
    public function setShippingRule(\StructType\Field $shippingRule = null)
    {
        $this->ShippingRule = $shippingRule;
        return $this;
    }
    /**
     * Get UndershipThreshold value
     * @return \StructType\Field|null
     */
    public function getUndershipThreshold()
    {
        return $this->UndershipThreshold;
    }
    /**
     * Set UndershipThreshold value
     * @param \StructType\Field $undershipThreshold
     * @return \StructType\Details
     */
    public function setUndershipThreshold(\StructType\Field $undershipThreshold = null)
    {
        $this->UndershipThreshold = $undershipThreshold;
        return $this;
    }
    /**
     * Get OvershipThreshold value
     * @return \StructType\Field|null
     */
    public function getOvershipThreshold()
    {
        return $this->OvershipThreshold;
    }
    /**
     * Set OvershipThreshold value
     * @param \StructType\Field $overshipThreshold
     * @return \StructType\Details
     */
    public function setOvershipThreshold(\StructType\Field $overshipThreshold = null)
    {
        $this->OvershipThreshold = $overshipThreshold;
        return $this;
    }
    /**
     * Get Completed value
     * @return \StructType\Field|null
     */
    public function getCompleted()
    {
        return $this->Completed;
    }
    /**
     * Set Completed value
     * @param \StructType\Field $completed
     * @return \StructType\Details
     */
    public function setCompleted(\StructType\Field $completed = null)
    {
        $this->Completed = $completed;
        return $this;
    }
    /**
     * Get MarkForPO value
     * @return \StructType\Field|null
     */
    public function getMarkForPO()
    {
        return $this->MarkForPO;
    }
    /**
     * Set MarkForPO value
     * @param \StructType\Field $markForPO
     * @return \StructType\Details
     */
    public function setMarkForPO(\StructType\Field $markForPO = null)
    {
        $this->MarkForPO = $markForPO;
        return $this;
    }
    /**
     * Get POSource value
     * @return \StructType\Field|null
     */
    public function getPOSource()
    {
        return $this->POSource;
    }
    /**
     * Set POSource value
     * @param \StructType\Field $pOSource
     * @return \StructType\Details
     */
    public function setPOSource(\StructType\Field $pOSource = null)
    {
        $this->POSource = $pOSource;
        return $this;
    }
    /**
     * Get POCreationDate value
     * @return \StructType\Field|null
     */
    public function getPOCreationDate()
    {
        return $this->POCreationDate;
    }
    /**
     * Set POCreationDate value
     * @param \StructType\Field $pOCreationDate
     * @return \StructType\Details
     */
    public function setPOCreationDate(\StructType\Field $pOCreationDate = null)
    {
        $this->POCreationDate = $pOCreationDate;
        return $this;
    }
    /**
     * Get LotSerialNbr value
     * @return \StructType\Field|null
     */
    public function getLotSerialNbr()
    {
        return $this->LotSerialNbr;
    }
    /**
     * Set LotSerialNbr value
     * @param \StructType\Field $lotSerialNbr
     * @return \StructType\Details
     */
    public function setLotSerialNbr(\StructType\Field $lotSerialNbr = null)
    {
        $this->LotSerialNbr = $lotSerialNbr;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return \StructType\Field|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param \StructType\Field $expirationDate
     * @return \StructType\Details
     */
    public function setExpirationDate(\StructType\Field $expirationDate = null)
    {
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return \StructType\Field|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param \StructType\Field $reasonCode
     * @return \StructType\Details
     */
    public function setReasonCode(\StructType\Field $reasonCode = null)
    {
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get SalespersonID value
     * @return \StructType\Field|null
     */
    public function getSalespersonID()
    {
        return $this->SalespersonID;
    }
    /**
     * Set SalespersonID value
     * @param \StructType\Field $salespersonID
     * @return \StructType\Details
     */
    public function setSalespersonID(\StructType\Field $salespersonID = null)
    {
        $this->SalespersonID = $salespersonID;
        return $this;
    }
    /**
     * Get TaxCategory value
     * @return \StructType\Field|null
     */
    public function getTaxCategory()
    {
        return $this->TaxCategory;
    }
    /**
     * Set TaxCategory value
     * @param \StructType\Field $taxCategory
     * @return \StructType\Details
     */
    public function setTaxCategory(\StructType\Field $taxCategory = null)
    {
        $this->TaxCategory = $taxCategory;
        return $this;
    }
    /**
     * Get EntityUsageType value
     * @return \StructType\Field|null
     */
    public function getEntityUsageType()
    {
        return $this->EntityUsageType;
    }
    /**
     * Set EntityUsageType value
     * @param \StructType\Field $entityUsageType
     * @return \StructType\Details
     */
    public function setEntityUsageType(\StructType\Field $entityUsageType = null)
    {
        $this->EntityUsageType = $entityUsageType;
        return $this;
    }
    /**
     * Get Commissionable value
     * @return \StructType\Field|null
     */
    public function getCommissionable()
    {
        return $this->Commissionable;
    }
    /**
     * Set Commissionable value
     * @param \StructType\Field $commissionable
     * @return \StructType\Details
     */
    public function setCommissionable(\StructType\Field $commissionable = null)
    {
        $this->Commissionable = $commissionable;
        return $this;
    }
    /**
     * Get BlanketSORefNbr value
     * @return \StructType\Field|null
     */
    public function getBlanketSORefNbr()
    {
        return $this->BlanketSORefNbr;
    }
    /**
     * Set BlanketSORefNbr value
     * @param \StructType\Field $blanketSORefNbr
     * @return \StructType\Details
     */
    public function setBlanketSORefNbr(\StructType\Field $blanketSORefNbr = null)
    {
        $this->BlanketSORefNbr = $blanketSORefNbr;
        return $this;
    }
    /**
     * Get AlternateID value
     * @return \StructType\Field|null
     */
    public function getAlternateID()
    {
        return $this->AlternateID;
    }
    /**
     * Set AlternateID value
     * @param \StructType\Field $alternateID
     * @return \StructType\Details
     */
    public function setAlternateID(\StructType\Field $alternateID = null)
    {
        $this->AlternateID = $alternateID;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\Field|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param \StructType\Field $account
     * @return \StructType\Details
     */
    public function setAccount(\StructType\Field $account = null)
    {
        $this->Account = $account;
        return $this;
    }
    /**
     * Get Subaccount value
     * @return \StructType\Field|null
     */
    public function getSubaccount()
    {
        return $this->Subaccount;
    }
    /**
     * Set Subaccount value
     * @param \StructType\Field $subaccount
     * @return \StructType\Details
     */
    public function setSubaccount(\StructType\Field $subaccount = null)
    {
        $this->Subaccount = $subaccount;
        return $this;
    }
    /**
     * Get ProjectTask value
     * @return \StructType\Field|null
     */
    public function getProjectTask()
    {
        return $this->ProjectTask;
    }
    /**
     * Set ProjectTask value
     * @param \StructType\Field $projectTask
     * @return \StructType\Details
     */
    public function setProjectTask(\StructType\Field $projectTask = null)
    {
        $this->ProjectTask = $projectTask;
        return $this;
    }
    /**
     * Get CostCode value
     * @return \StructType\Field|null
     */
    public function getCostCode()
    {
        return $this->CostCode;
    }
    /**
     * Set CostCode value
     * @param \StructType\Field $costCode
     * @return \StructType\Details
     */
    public function setCostCode(\StructType\Field $costCode = null)
    {
        $this->CostCode = $costCode;
        return $this;
    }
    /**
     * Get UnitPriceForDR value
     * @return \StructType\Field|null
     */
    public function getUnitPriceForDR()
    {
        return $this->UnitPriceForDR;
    }
    /**
     * Set UnitPriceForDR value
     * @param \StructType\Field $unitPriceForDR
     * @return \StructType\Details
     */
    public function setUnitPriceForDR(\StructType\Field $unitPriceForDR = null)
    {
        $this->UnitPriceForDR = $unitPriceForDR;
        return $this;
    }
    /**
     * Get DiscountPercentForDR value
     * @return \StructType\Field|null
     */
    public function getDiscountPercentForDR()
    {
        return $this->DiscountPercentForDR;
    }
    /**
     * Set DiscountPercentForDR value
     * @param \StructType\Field $discountPercentForDR
     * @return \StructType\Details
     */
    public function setDiscountPercentForDR(\StructType\Field $discountPercentForDR = null)
    {
        $this->DiscountPercentForDR = $discountPercentForDR;
        return $this;
    }
    /**
     * Get ROTOrRUTDeductible value
     * @return \StructType\Field|null
     */
    public function getROTOrRUTDeductible()
    {
        return $this->ROTOrRUTDeductible;
    }
    /**
     * Set ROTOrRUTDeductible value
     * @param \StructType\Field $rOTOrRUTDeductible
     * @return \StructType\Details
     */
    public function setROTOrRUTDeductible(\StructType\Field $rOTOrRUTDeductible = null)
    {
        $this->ROTOrRUTDeductible = $rOTOrRUTDeductible;
        return $this;
    }
    /**
     * Get ItemType value
     * @return \StructType\Field|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @param \StructType\Field $itemType
     * @return \StructType\Details
     */
    public function setItemType(\StructType\Field $itemType = null)
    {
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get TypeOfWork value
     * @return \StructType\Field|null
     */
    public function getTypeOfWork()
    {
        return $this->TypeOfWork;
    }
    /**
     * Set TypeOfWork value
     * @param \StructType\Field $typeOfWork
     * @return \StructType\Details
     */
    public function setTypeOfWork(\StructType\Field $typeOfWork = null)
    {
        $this->TypeOfWork = $typeOfWork;
        return $this;
    }
    /**
     * Get DeductibleAmount value
     * @return \StructType\Field|null
     */
    public function getDeductibleAmount()
    {
        return $this->DeductibleAmount;
    }
    /**
     * Set DeductibleAmount value
     * @param \StructType\Field $deductibleAmount
     * @return \StructType\Details
     */
    public function setDeductibleAmount(\StructType\Field $deductibleAmount = null)
    {
        $this->DeductibleAmount = $deductibleAmount;
        return $this;
    }
    /**
     * Get MarkForProduction value
     * @return \StructType\Field|null
     */
    public function getMarkForProduction()
    {
        return $this->MarkForProduction;
    }
    /**
     * Set MarkForProduction value
     * @param \StructType\Field $markForProduction
     * @return \StructType\Details
     */
    public function setMarkForProduction(\StructType\Field $markForProduction = null)
    {
        $this->MarkForProduction = $markForProduction;
        return $this;
    }
    /**
     * Get ProdOrderType value
     * @return \StructType\Field|null
     */
    public function getProdOrderType()
    {
        return $this->ProdOrderType;
    }
    /**
     * Set ProdOrderType value
     * @param \StructType\Field $prodOrderType
     * @return \StructType\Details
     */
    public function setProdOrderType(\StructType\Field $prodOrderType = null)
    {
        $this->ProdOrderType = $prodOrderType;
        return $this;
    }
    /**
     * Get ProductionNbr value
     * @return \StructType\Field|null
     */
    public function getProductionNbr()
    {
        return $this->ProductionNbr;
    }
    /**
     * Set ProductionNbr value
     * @param \StructType\Field $productionNbr
     * @return \StructType\Details
     */
    public function setProductionNbr(\StructType\Field $productionNbr = null)
    {
        $this->ProductionNbr = $productionNbr;
        return $this;
    }
    /**
     * Get EstimateID value
     * @return \StructType\Field|null
     */
    public function getEstimateID()
    {
        return $this->EstimateID;
    }
    /**
     * Set EstimateID value
     * @param \StructType\Field $estimateID
     * @return \StructType\Details
     */
    public function setEstimateID(\StructType\Field $estimateID = null)
    {
        $this->EstimateID = $estimateID;
        return $this;
    }
    /**
     * Get EstRevision value
     * @return \StructType\Field|null
     */
    public function getEstRevision()
    {
        return $this->EstRevision;
    }
    /**
     * Set EstRevision value
     * @param \StructType\Field $estRevision
     * @return \StructType\Details
     */
    public function setEstRevision(\StructType\Field $estRevision = null)
    {
        $this->EstRevision = $estRevision;
        return $this;
    }
    /**
     * Get ParentLineNbr value
     * @return \StructType\Field|null
     */
    public function getParentLineNbr()
    {
        return $this->ParentLineNbr;
    }
    /**
     * Set ParentLineNbr value
     * @param \StructType\Field $parentLineNbr
     * @return \StructType\Details
     */
    public function setParentLineNbr(\StructType\Field $parentLineNbr = null)
    {
        $this->ParentLineNbr = $parentLineNbr;
        return $this;
    }
    /**
     * Get IsSupplemental value
     * @return \StructType\Field|null
     */
    public function getIsSupplemental()
    {
        return $this->IsSupplemental;
    }
    /**
     * Set IsSupplemental value
     * @param \StructType\Field $isSupplemental
     * @return \StructType\Details
     */
    public function setIsSupplemental(\StructType\Field $isSupplemental = null)
    {
        $this->IsSupplemental = $isSupplemental;
        return $this;
    }
    /**
     * Get ConfigKey value
     * @return \StructType\Field|null
     */
    public function getConfigKey()
    {
        return $this->ConfigKey;
    }
    /**
     * Set ConfigKey value
     * @param \StructType\Field $configKey
     * @return \StructType\Details
     */
    public function setConfigKey(\StructType\Field $configKey = null)
    {
        $this->ConfigKey = $configKey;
        return $this;
    }
    /**
     * Get NoteText value
     * @return \StructType\Field|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param \StructType\Field $noteText
     * @return \StructType\Details
     */
    public function setNoteText(\StructType\Field $noteText = null)
    {
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get Availability value
     * @return \StructType\Field|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param \StructType\Field $availability
     * @return \StructType\Details
     */
    public function setAvailability(\StructType\Field $availability = null)
    {
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\DetailsServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\DetailsServiceCommands $serviceCommands
     * @return \StructType\Details
     */
    public function setServiceCommands(\StructType\DetailsServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
