<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Container StructType
 * @subpackage Structs
 */
class Container extends AbstractStructBase
{
    /**
     * The Fields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfField
     */
    public $Fields;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCommand
     */
    public $ServiceCommands;
    /**
     * The Children
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfContainer
     */
    public $Children;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * Constructor method for Container
     * @uses Container::setFields()
     * @uses Container::setName()
     * @uses Container::setServiceCommands()
     * @uses Container::setChildren()
     * @uses Container::setDisplayName()
     * @param \ArrayType\ArrayOfField $fields
     * @param string $name
     * @param \ArrayType\ArrayOfCommand $serviceCommands
     * @param \ArrayType\ArrayOfContainer $children
     * @param string $displayName
     */
    public function __construct(\ArrayType\ArrayOfField $fields = null, $name = null, \ArrayType\ArrayOfCommand $serviceCommands = null, \ArrayType\ArrayOfContainer $children = null, $displayName = null)
    {
        $this
            ->setFields($fields)
            ->setName($name)
            ->setServiceCommands($serviceCommands)
            ->setChildren($children)
            ->setDisplayName($displayName);
    }
    /**
     * Get Fields value
     * @return \ArrayType\ArrayOfField|null
     */
    public function getFields()
    {
        return $this->Fields;
    }
    /**
     * Set Fields value
     * @param \ArrayType\ArrayOfField $fields
     * @return \StructType\Container
     */
    public function setFields(\ArrayType\ArrayOfField $fields = null)
    {
        $this->Fields = $fields;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Container
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \ArrayType\ArrayOfCommand|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \ArrayType\ArrayOfCommand $serviceCommands
     * @return \StructType\Container
     */
    public function setServiceCommands(\ArrayType\ArrayOfCommand $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
    /**
     * Get Children value
     * @return \ArrayType\ArrayOfContainer|null
     */
    public function getChildren()
    {
        return $this->Children;
    }
    /**
     * Set Children value
     * @param \ArrayType\ArrayOfContainer $children
     * @return \StructType\Container
     */
    public function setChildren(\ArrayType\ArrayOfContainer $children = null)
    {
        $this->Children = $children;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\Container
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
}
