<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SchemaMode EnumType
 * @subpackage Enumerations
 */
class SchemaMode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Basic'
     * @return string 'Basic'
     */
    const VALUE_BASIC = 'Basic';
    /**
     * Constant for value 'Detailed'
     * @return string 'Detailed'
     */
    const VALUE_DETAILED = 'Detailed';
    /**
     * Constant for value 'DetailedWithHidden'
     * @return string 'DetailedWithHidden'
     */
    const VALUE_DETAILED_WITH_HIDDEN = 'DetailedWithHidden';
    /**
     * Return allowed values
     * @uses self::VALUE_BASIC
     * @uses self::VALUE_DETAILED
     * @uses self::VALUE_DETAILED_WITH_HIDDEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASIC,
            self::VALUE_DETAILED,
            self::VALUE_DETAILED_WITH_HIDDEN,
        );
    }
}
