<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RisksRiskStatus StructType
 * @subpackage Structs
 */
class RisksRiskStatus extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The RiskStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $RiskStatus;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RisksRiskStatusServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for RisksRiskStatus
     * @uses RisksRiskStatus::setDisplayName()
     * @uses RisksRiskStatus::setRiskStatus()
     * @uses RisksRiskStatus::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $riskStatus
     * @param \StructType\RisksRiskStatusServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $riskStatus = null, \StructType\RisksRiskStatusServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setRiskStatus($riskStatus)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\RisksRiskStatus
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get RiskStatus value
     * @return \StructType\Field|null
     */
    public function getRiskStatus()
    {
        return $this->RiskStatus;
    }
    /**
     * Set RiskStatus value
     * @param \StructType\Field $riskStatus
     * @return \StructType\RisksRiskStatus
     */
    public function setRiskStatus(\StructType\Field $riskStatus = null)
    {
        $this->RiskStatus = $riskStatus;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\RisksRiskStatusServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\RisksRiskStatusServiceCommands $serviceCommands
     * @return \StructType\RisksRiskStatus
     */
    public function setServiceCommands(\StructType\RisksRiskStatusServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
