<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressLookup StructType
 * @subpackage Structs
 */
class AddressLookup extends AbstractStructBase
{
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The SearchAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $SearchAddress;
    /**
     * The ViewName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $ViewName;
    /**
     * The AddressLine1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AddressLine2;
    /**
     * The AddressLine3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $AddressLine3;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $City;
    /**
     * The CountryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $CountryID;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $State;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $PostalCode;
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Field
     */
    public $Longitude;
    /**
     * The ServiceCommands
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressLookupServiceCommands
     */
    public $ServiceCommands;
    /**
     * Constructor method for AddressLookup
     * @uses AddressLookup::setDisplayName()
     * @uses AddressLookup::setSearchAddress()
     * @uses AddressLookup::setViewName()
     * @uses AddressLookup::setAddressLine1()
     * @uses AddressLookup::setAddressLine2()
     * @uses AddressLookup::setAddressLine3()
     * @uses AddressLookup::setCity()
     * @uses AddressLookup::setCountryID()
     * @uses AddressLookup::setState()
     * @uses AddressLookup::setPostalCode()
     * @uses AddressLookup::setLatitude()
     * @uses AddressLookup::setLongitude()
     * @uses AddressLookup::setServiceCommands()
     * @param string $displayName
     * @param \StructType\Field $searchAddress
     * @param \StructType\Field $viewName
     * @param \StructType\Field $addressLine1
     * @param \StructType\Field $addressLine2
     * @param \StructType\Field $addressLine3
     * @param \StructType\Field $city
     * @param \StructType\Field $countryID
     * @param \StructType\Field $state
     * @param \StructType\Field $postalCode
     * @param \StructType\Field $latitude
     * @param \StructType\Field $longitude
     * @param \StructType\AddressLookupServiceCommands $serviceCommands
     */
    public function __construct($displayName = null, \StructType\Field $searchAddress = null, \StructType\Field $viewName = null, \StructType\Field $addressLine1 = null, \StructType\Field $addressLine2 = null, \StructType\Field $addressLine3 = null, \StructType\Field $city = null, \StructType\Field $countryID = null, \StructType\Field $state = null, \StructType\Field $postalCode = null, \StructType\Field $latitude = null, \StructType\Field $longitude = null, \StructType\AddressLookupServiceCommands $serviceCommands = null)
    {
        $this
            ->setDisplayName($displayName)
            ->setSearchAddress($searchAddress)
            ->setViewName($viewName)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setCity($city)
            ->setCountryID($countryID)
            ->setState($state)
            ->setPostalCode($postalCode)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setServiceCommands($serviceCommands);
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\AddressLookup
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get SearchAddress value
     * @return \StructType\Field|null
     */
    public function getSearchAddress()
    {
        return $this->SearchAddress;
    }
    /**
     * Set SearchAddress value
     * @param \StructType\Field $searchAddress
     * @return \StructType\AddressLookup
     */
    public function setSearchAddress(\StructType\Field $searchAddress = null)
    {
        $this->SearchAddress = $searchAddress;
        return $this;
    }
    /**
     * Get ViewName value
     * @return \StructType\Field|null
     */
    public function getViewName()
    {
        return $this->ViewName;
    }
    /**
     * Set ViewName value
     * @param \StructType\Field $viewName
     * @return \StructType\AddressLookup
     */
    public function setViewName(\StructType\Field $viewName = null)
    {
        $this->ViewName = $viewName;
        return $this;
    }
    /**
     * Get AddressLine1 value
     * @return \StructType\Field|null
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param \StructType\Field $addressLine1
     * @return \StructType\AddressLookup
     */
    public function setAddressLine1(\StructType\Field $addressLine1 = null)
    {
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return \StructType\Field|null
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param \StructType\Field $addressLine2
     * @return \StructType\AddressLookup
     */
    public function setAddressLine2(\StructType\Field $addressLine2 = null)
    {
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get AddressLine3 value
     * @return \StructType\Field|null
     */
    public function getAddressLine3()
    {
        return $this->AddressLine3;
    }
    /**
     * Set AddressLine3 value
     * @param \StructType\Field $addressLine3
     * @return \StructType\AddressLookup
     */
    public function setAddressLine3(\StructType\Field $addressLine3 = null)
    {
        $this->AddressLine3 = $addressLine3;
        return $this;
    }
    /**
     * Get City value
     * @return \StructType\Field|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param \StructType\Field $city
     * @return \StructType\AddressLookup
     */
    public function setCity(\StructType\Field $city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get CountryID value
     * @return \StructType\Field|null
     */
    public function getCountryID()
    {
        return $this->CountryID;
    }
    /**
     * Set CountryID value
     * @param \StructType\Field $countryID
     * @return \StructType\AddressLookup
     */
    public function setCountryID(\StructType\Field $countryID = null)
    {
        $this->CountryID = $countryID;
        return $this;
    }
    /**
     * Get State value
     * @return \StructType\Field|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param \StructType\Field $state
     * @return \StructType\AddressLookup
     */
    public function setState(\StructType\Field $state = null)
    {
        $this->State = $state;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return \StructType\Field|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param \StructType\Field $postalCode
     * @return \StructType\AddressLookup
     */
    public function setPostalCode(\StructType\Field $postalCode = null)
    {
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Latitude value
     * @return \StructType\Field|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param \StructType\Field $latitude
     * @return \StructType\AddressLookup
     */
    public function setLatitude(\StructType\Field $latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return \StructType\Field|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param \StructType\Field $longitude
     * @return \StructType\AddressLookup
     */
    public function setLongitude(\StructType\Field $longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get ServiceCommands value
     * @return \StructType\AddressLookupServiceCommands|null
     */
    public function getServiceCommands()
    {
        return $this->ServiceCommands;
    }
    /**
     * Set ServiceCommands value
     * @param \StructType\AddressLookupServiceCommands $serviceCommands
     * @return \StructType\AddressLookup
     */
    public function setServiceCommands(\StructType\AddressLookupServiceCommands $serviceCommands = null)
    {
        $this->ServiceCommands = $serviceCommands;
        return $this;
    }
}
