<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetSchema $parameters
     * @return \StructType\SetSchemaResponse|bool
     */
    public function SetSchema(\StructType\SetSchema $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetBusinessDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetBusinessDate $parameters
     * @return \StructType\SetBusinessDateResponse|bool
     */
    public function SetBusinessDate(\StructType\SetBusinessDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetBusinessDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetLocaleName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetLocaleName $parameters
     * @return \StructType\SetLocaleNameResponse|bool
     */
    public function SetLocaleName(\StructType\SetLocaleName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetLocaleName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetSchemaMode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetSchemaMode $parameters
     * @return \StructType\SetSchemaModeResponse|bool
     */
    public function SetSchemaMode(\StructType\SetSchemaMode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetSchemaMode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetBusinessDateResponse|\StructType\SetLocaleNameResponse|\StructType\SetSchemaModeResponse|\StructType\SetSchemaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
