<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNNIAgreement ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNNIAgreement
 * @subpackage Arrays
 */
class ArrayOfNNIAgreement extends AbstractStructArrayBase
{
    /**
     * The NNIAgreement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NNIAgreement[]
     */
    public $NNIAgreement;
    /**
     * Constructor method for ArrayOfNNIAgreement
     * @uses ArrayOfNNIAgreement::setNNIAgreement()
     * @param \StructType\NNIAgreement[] $nNIAgreement
     */
    public function __construct(array $nNIAgreement = array())
    {
        $this
            ->setNNIAgreement($nNIAgreement);
    }
    /**
     * Get NNIAgreement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NNIAgreement[]|null
     */
    public function getNNIAgreement()
    {
        return isset($this->NNIAgreement) ? $this->NNIAgreement : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNNIAgreement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNNIAgreement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNNIAgreementForArrayConstraintsFromSetNNIAgreement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNNIAgreementNNIAgreementItem) {
            // validation for constraint: itemType
            if (!$arrayOfNNIAgreementNNIAgreementItem instanceof \StructType\NNIAgreement) {
                $invalidValues[] = is_object($arrayOfNNIAgreementNNIAgreementItem) ? get_class($arrayOfNNIAgreementNNIAgreementItem) : sprintf('%s(%s)', gettype($arrayOfNNIAgreementNNIAgreementItem), var_export($arrayOfNNIAgreementNNIAgreementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NNIAgreement property can only contain items of type \StructType\NNIAgreement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NNIAgreement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NNIAgreement[] $nNIAgreement
     * @return \ArrayType\ArrayOfNNIAgreement
     */
    public function setNNIAgreement(array $nNIAgreement = array())
    {
        // validation for constraint: array
        if ('' !== ($nNIAgreementArrayErrorMessage = self::validateNNIAgreementForArrayConstraintsFromSetNNIAgreement($nNIAgreement))) {
            throw new \InvalidArgumentException($nNIAgreementArrayErrorMessage, __LINE__);
        }
        if (is_null($nNIAgreement) || (is_array($nNIAgreement) && empty($nNIAgreement))) {
            unset($this->NNIAgreement);
        } else {
            $this->NNIAgreement = $nNIAgreement;
        }
        return $this;
    }
    /**
     * Add item to NNIAgreement value
     * @throws \InvalidArgumentException
     * @param \StructType\NNIAgreement $item
     * @return \ArrayType\ArrayOfNNIAgreement
     */
    public function addToNNIAgreement(\StructType\NNIAgreement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NNIAgreement) {
            throw new \InvalidArgumentException(sprintf('The NNIAgreement property can only contain items of type \StructType\NNIAgreement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NNIAgreement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NNIAgreement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NNIAgreement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NNIAgreement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NNIAgreement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NNIAgreement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NNIAgreement
     */
    public function getAttributeName()
    {
        return 'NNIAgreement';
    }
}
