<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ProductType EnumType
 * @subpackage Enumerations
 */
class ProductType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'P2P'
     * @return string 'P2P'
     */
    const VALUE_P_2_P = 'P2P';
    /**
     * Constant for value 'NNI'
     * @return string 'NNI'
     */
    const VALUE_NNI = 'NNI';
    /**
     * Constant for value 'IA'
     * @return string 'IA'
     */
    const VALUE_IA = 'IA';
    /**
     * Constant for value 'IP'
     * @return string 'IP'
     */
    const VALUE_IP = 'IP';
    /**
     * Constant for value 'OpticalP2P'
     * @return string 'OpticalP2P'
     */
    const VALUE_OPTICAL_P_2_P = 'OpticalP2P';
    /**
     * Constant for value 'P2CCT'
     * @return string 'P2CCT'
     */
    const VALUE_P_2_CCT = 'P2CCT';
    /**
     * Constant for value 'NNI2CCT'
     * @return string 'NNI2CCT'
     */
    const VALUE_NNI_2_CCT = 'NNI2CCT';
    /**
     * Constant for value 'SDWAN'
     * @return string 'SDWAN'
     */
    const VALUE_SDWAN = 'SDWAN';
    /**
     * Return allowed values
     * @uses self::VALUE_P_2_P
     * @uses self::VALUE_NNI
     * @uses self::VALUE_IA
     * @uses self::VALUE_IP
     * @uses self::VALUE_OPTICAL_P_2_P
     * @uses self::VALUE_P_2_CCT
     * @uses self::VALUE_NNI_2_CCT
     * @uses self::VALUE_SDWAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_P_2_P,
            self::VALUE_NNI,
            self::VALUE_IA,
            self::VALUE_IP,
            self::VALUE_OPTICAL_P_2_P,
            self::VALUE_P_2_CCT,
            self::VALUE_NNI_2_CCT,
            self::VALUE_SDWAN,
        );
    }
}
