<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PortAndBandwidth StructType
 * @subpackage Structs
 */
class PortAndBandwidth extends AbstractStructBase
{
    /**
     * The AEndPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AEndPort;
    /**
     * The BEndPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BEndPort;
    /**
     * The Bandwidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bandwidth;
    /**
     * Constructor method for PortAndBandwidth
     * @uses PortAndBandwidth::setAEndPort()
     * @uses PortAndBandwidth::setBEndPort()
     * @uses PortAndBandwidth::setBandwidth()
     * @param string $aEndPort
     * @param string $bEndPort
     * @param string $bandwidth
     */
    public function __construct($aEndPort = null, $bEndPort = null, $bandwidth = null)
    {
        $this
            ->setAEndPort($aEndPort)
            ->setBEndPort($bEndPort)
            ->setBandwidth($bandwidth);
    }
    /**
     * Get AEndPort value
     * @return string|null
     */
    public function getAEndPort()
    {
        return $this->AEndPort;
    }
    /**
     * Set AEndPort value
     * @param string $aEndPort
     * @return \StructType\PortAndBandwidth
     */
    public function setAEndPort($aEndPort = null)
    {
        // validation for constraint: string
        if (!is_null($aEndPort) && !is_string($aEndPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aEndPort, true), gettype($aEndPort)), __LINE__);
        }
        $this->AEndPort = $aEndPort;
        return $this;
    }
    /**
     * Get BEndPort value
     * @return string|null
     */
    public function getBEndPort()
    {
        return $this->BEndPort;
    }
    /**
     * Set BEndPort value
     * @param string $bEndPort
     * @return \StructType\PortAndBandwidth
     */
    public function setBEndPort($bEndPort = null)
    {
        // validation for constraint: string
        if (!is_null($bEndPort) && !is_string($bEndPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bEndPort, true), gettype($bEndPort)), __LINE__);
        }
        $this->BEndPort = $bEndPort;
        return $this;
    }
    /**
     * Get Bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->Bandwidth;
    }
    /**
     * Set Bandwidth value
     * @param string $bandwidth
     * @return \StructType\PortAndBandwidth
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: string
        if (!is_null($bandwidth) && !is_string($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bandwidth, true), gettype($bandwidth)), __LINE__);
        }
        $this->Bandwidth = $bandwidth;
        return $this;
    }
}
