<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NNIAgreement StructType
 * @subpackage Structs
 */
class NNIAgreement extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The Postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Postcode;
    /**
     * The Port
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Port;
    /**
     * The EthernetBearerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EthernetBearerReference;
    /**
     * Constructor method for NNIAgreement
     * @uses NNIAgreement::setId()
     * @uses NNIAgreement::setCustomerId()
     * @uses NNIAgreement::setPostcode()
     * @uses NNIAgreement::setPort()
     * @uses NNIAgreement::setEthernetBearerReference()
     * @param int $id
     * @param int $customerId
     * @param string $postcode
     * @param string $port
     * @param string $ethernetBearerReference
     */
    public function __construct($id = null, $customerId = null, $postcode = null, $port = null, $ethernetBearerReference = null)
    {
        $this
            ->setId($id)
            ->setCustomerId($customerId)
            ->setPostcode($postcode)
            ->setPort($port)
            ->setEthernetBearerReference($ethernetBearerReference);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\NNIAgreement
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\NNIAgreement
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\NNIAgreement
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get Port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->Port;
    }
    /**
     * Set Port value
     * @param string $port
     * @return \StructType\NNIAgreement
     */
    public function setPort($port = null)
    {
        // validation for constraint: string
        if (!is_null($port) && !is_string($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($port, true), gettype($port)), __LINE__);
        }
        $this->Port = $port;
        return $this;
    }
    /**
     * Get EthernetBearerReference value
     * @return string|null
     */
    public function getEthernetBearerReference()
    {
        return $this->EthernetBearerReference;
    }
    /**
     * Set EthernetBearerReference value
     * @param string $ethernetBearerReference
     * @return \StructType\NNIAgreement
     */
    public function setEthernetBearerReference($ethernetBearerReference = null)
    {
        // validation for constraint: string
        if (!is_null($ethernetBearerReference) && !is_string($ethernetBearerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ethernetBearerReference, true), gettype($ethernetBearerReference)), __LINE__);
        }
        $this->EthernetBearerReference = $ethernetBearerReference;
        return $this;
    }
}
