<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Quotation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Quotation
 * @subpackage Structs
 */
class Quotation extends AbstractStructBase
{
    /**
     * The QuotationId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuotationId;
    /**
     * The DateCreated
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateCreated;
    /**
     * The DateOrdered
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateOrdered;
    /**
     * The CircuitDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CircuitDetails
     */
    public $CircuitDetails;
    /**
     * The AdditionalProperties
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfItem
     */
    public $AdditionalProperties;
    /**
     * The QuoteOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfQuotationLine
     */
    public $QuoteOptions;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for Quotation
     * @uses Quotation::setQuotationId()
     * @uses Quotation::setDateCreated()
     * @uses Quotation::setDateOrdered()
     * @uses Quotation::setCircuitDetails()
     * @uses Quotation::setAdditionalProperties()
     * @uses Quotation::setQuoteOptions()
     * @uses Quotation::setErrorMessage()
     * @param int $quotationId
     * @param string $dateCreated
     * @param string $dateOrdered
     * @param \StructType\CircuitDetails $circuitDetails
     * @param \ArrayType\ArrayOfItem $additionalProperties
     * @param \ArrayType\ArrayOfQuotationLine $quoteOptions
     * @param string $errorMessage
     */
    public function __construct($quotationId = null, $dateCreated = null, $dateOrdered = null, \StructType\CircuitDetails $circuitDetails = null, \ArrayType\ArrayOfItem $additionalProperties = null, \ArrayType\ArrayOfQuotationLine $quoteOptions = null, $errorMessage = null)
    {
        $this
            ->setQuotationId($quotationId)
            ->setDateCreated($dateCreated)
            ->setDateOrdered($dateOrdered)
            ->setCircuitDetails($circuitDetails)
            ->setAdditionalProperties($additionalProperties)
            ->setQuoteOptions($quoteOptions)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get QuotationId value
     * @return int
     */
    public function getQuotationId()
    {
        return $this->QuotationId;
    }
    /**
     * Set QuotationId value
     * @param int $quotationId
     * @return \StructType\Quotation
     */
    public function setQuotationId($quotationId = null)
    {
        // validation for constraint: int
        if (!is_null($quotationId) && !(is_int($quotationId) || ctype_digit($quotationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quotationId, true), gettype($quotationId)), __LINE__);
        }
        $this->QuotationId = $quotationId;
        return $this;
    }
    /**
     * Get DateCreated value
     * @return string
     */
    public function getDateCreated()
    {
        return $this->DateCreated;
    }
    /**
     * Set DateCreated value
     * @param string $dateCreated
     * @return \StructType\Quotation
     */
    public function setDateCreated($dateCreated = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreated) && !is_string($dateCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCreated, true), gettype($dateCreated)), __LINE__);
        }
        $this->DateCreated = $dateCreated;
        return $this;
    }
    /**
     * Get DateOrdered value
     * @return string
     */
    public function getDateOrdered()
    {
        return $this->DateOrdered;
    }
    /**
     * Set DateOrdered value
     * @param string $dateOrdered
     * @return \StructType\Quotation
     */
    public function setDateOrdered($dateOrdered = null)
    {
        // validation for constraint: string
        if (!is_null($dateOrdered) && !is_string($dateOrdered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOrdered, true), gettype($dateOrdered)), __LINE__);
        }
        $this->DateOrdered = $dateOrdered;
        return $this;
    }
    /**
     * Get CircuitDetails value
     * @return \StructType\CircuitDetails|null
     */
    public function getCircuitDetails()
    {
        return $this->CircuitDetails;
    }
    /**
     * Set CircuitDetails value
     * @param \StructType\CircuitDetails $circuitDetails
     * @return \StructType\Quotation
     */
    public function setCircuitDetails(\StructType\CircuitDetails $circuitDetails = null)
    {
        $this->CircuitDetails = $circuitDetails;
        return $this;
    }
    /**
     * Get AdditionalProperties value
     * @return \ArrayType\ArrayOfItem|null
     */
    public function getAdditionalProperties()
    {
        return $this->AdditionalProperties;
    }
    /**
     * Set AdditionalProperties value
     * @param \ArrayType\ArrayOfItem $additionalProperties
     * @return \StructType\Quotation
     */
    public function setAdditionalProperties(\ArrayType\ArrayOfItem $additionalProperties = null)
    {
        $this->AdditionalProperties = $additionalProperties;
        return $this;
    }
    /**
     * Get QuoteOptions value
     * @return \ArrayType\ArrayOfQuotationLine|null
     */
    public function getQuoteOptions()
    {
        return $this->QuoteOptions;
    }
    /**
     * Set QuoteOptions value
     * @param \ArrayType\ArrayOfQuotationLine $quoteOptions
     * @return \StructType\Quotation
     */
    public function setQuoteOptions(\ArrayType\ArrayOfQuotationLine $quoteOptions = null)
    {
        $this->QuoteOptions = $quoteOptions;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\Quotation
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
