<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCloudConnectRequest ArrayType
 * @subpackage Arrays
 */
class ArrayOfCloudConnectRequest extends AbstractStructArrayBase
{
    /**
     * The CloudConnectRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CloudConnectRequest[]
     */
    public $CloudConnectRequest;
    /**
     * Constructor method for ArrayOfCloudConnectRequest
     * @uses ArrayOfCloudConnectRequest::setCloudConnectRequest()
     * @param \StructType\CloudConnectRequest[] $cloudConnectRequest
     */
    public function __construct(array $cloudConnectRequest = array())
    {
        $this
            ->setCloudConnectRequest($cloudConnectRequest);
    }
    /**
     * Get CloudConnectRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CloudConnectRequest[]|null
     */
    public function getCloudConnectRequest()
    {
        return isset($this->CloudConnectRequest) ? $this->CloudConnectRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCloudConnectRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCloudConnectRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCloudConnectRequestForArrayConstraintsFromSetCloudConnectRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCloudConnectRequestCloudConnectRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfCloudConnectRequestCloudConnectRequestItem instanceof \StructType\CloudConnectRequest) {
                $invalidValues[] = is_object($arrayOfCloudConnectRequestCloudConnectRequestItem) ? get_class($arrayOfCloudConnectRequestCloudConnectRequestItem) : sprintf('%s(%s)', gettype($arrayOfCloudConnectRequestCloudConnectRequestItem), var_export($arrayOfCloudConnectRequestCloudConnectRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CloudConnectRequest property can only contain items of type \StructType\CloudConnectRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CloudConnectRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CloudConnectRequest[] $cloudConnectRequest
     * @return \ArrayType\ArrayOfCloudConnectRequest
     */
    public function setCloudConnectRequest(array $cloudConnectRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($cloudConnectRequestArrayErrorMessage = self::validateCloudConnectRequestForArrayConstraintsFromSetCloudConnectRequest($cloudConnectRequest))) {
            throw new \InvalidArgumentException($cloudConnectRequestArrayErrorMessage, __LINE__);
        }
        if (is_null($cloudConnectRequest) || (is_array($cloudConnectRequest) && empty($cloudConnectRequest))) {
            unset($this->CloudConnectRequest);
        } else {
            $this->CloudConnectRequest = $cloudConnectRequest;
        }
        return $this;
    }
    /**
     * Add item to CloudConnectRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\CloudConnectRequest $item
     * @return \ArrayType\ArrayOfCloudConnectRequest
     */
    public function addToCloudConnectRequest(\StructType\CloudConnectRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CloudConnectRequest) {
            throw new \InvalidArgumentException(sprintf('The CloudConnectRequest property can only contain items of type \StructType\CloudConnectRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CloudConnectRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CloudConnectRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CloudConnectRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CloudConnectRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CloudConnectRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CloudConnectRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CloudConnectRequest
     */
    public function getAttributeName()
    {
        return 'CloudConnectRequest';
    }
}
