<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLocationIdentifier ArrayType
 * @subpackage Arrays
 */
class ArrayOfLocationIdentifier extends AbstractStructArrayBase
{
    /**
     * The LocationIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LocationIdentifier[]
     */
    public $LocationIdentifier;
    /**
     * Constructor method for ArrayOfLocationIdentifier
     * @uses ArrayOfLocationIdentifier::setLocationIdentifier()
     * @param \StructType\LocationIdentifier[] $locationIdentifier
     */
    public function __construct(array $locationIdentifier = array())
    {
        $this
            ->setLocationIdentifier($locationIdentifier);
    }
    /**
     * Get LocationIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LocationIdentifier[]|null
     */
    public function getLocationIdentifier()
    {
        return isset($this->LocationIdentifier) ? $this->LocationIdentifier : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationIdentifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationIdentifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationIdentifierForArrayConstraintsFromSetLocationIdentifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLocationIdentifierLocationIdentifierItem) {
            // validation for constraint: itemType
            if (!$arrayOfLocationIdentifierLocationIdentifierItem instanceof \StructType\LocationIdentifier) {
                $invalidValues[] = is_object($arrayOfLocationIdentifierLocationIdentifierItem) ? get_class($arrayOfLocationIdentifierLocationIdentifierItem) : sprintf('%s(%s)', gettype($arrayOfLocationIdentifierLocationIdentifierItem), var_export($arrayOfLocationIdentifierLocationIdentifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LocationIdentifier property can only contain items of type \StructType\LocationIdentifier, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LocationIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LocationIdentifier[] $locationIdentifier
     * @return \ArrayType\ArrayOfLocationIdentifier
     */
    public function setLocationIdentifier(array $locationIdentifier = array())
    {
        // validation for constraint: array
        if ('' !== ($locationIdentifierArrayErrorMessage = self::validateLocationIdentifierForArrayConstraintsFromSetLocationIdentifier($locationIdentifier))) {
            throw new \InvalidArgumentException($locationIdentifierArrayErrorMessage, __LINE__);
        }
        if (is_null($locationIdentifier) || (is_array($locationIdentifier) && empty($locationIdentifier))) {
            unset($this->LocationIdentifier);
        } else {
            $this->LocationIdentifier = $locationIdentifier;
        }
        return $this;
    }
    /**
     * Add item to LocationIdentifier value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationIdentifier $item
     * @return \ArrayType\ArrayOfLocationIdentifier
     */
    public function addToLocationIdentifier(\StructType\LocationIdentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationIdentifier) {
            throw new \InvalidArgumentException(sprintf('The LocationIdentifier property can only contain items of type \StructType\LocationIdentifier, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LocationIdentifier[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LocationIdentifier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LocationIdentifier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LocationIdentifier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LocationIdentifier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LocationIdentifier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LocationIdentifier
     */
    public function getAttributeName()
    {
        return 'LocationIdentifier';
    }
}
